/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core;

import java.beans.Statement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.exceptions.NotEnoughMemoryException;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.common.utils.RuntimeMemory;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.osgi.framework.Bundle;

public class GuiCoreRegistry
extends CoreRegistry {
    public Session newSession(Timeseries timeseries, boolean focus) throws NotEnoughMemoryException {
        long maxmemory = RuntimeMemory.maxMemory();
        long usedmemory = RuntimeMemory.usedMemory();
        long requestedMemory = this.calcMemoryAllocation(timeseries);
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
        log.log((IStatus)new Status(1, "org.fao.fi.fishstat.gui.core.GuiCoreRegistry", "maxmemory=" + maxmemory + ", usedmemory=" + usedmemory + ", requestedMemory=" + requestedMemory));
        if (maxmemory - (usedmemory + requestedMemory) >= 20L) {
            GuiSession session = new GuiSession(timeseries);
            this.sessions.put(session.getDescriptor(), session);
            if (focus || this.sessionOnFocus == null) {
                this.sessionOnFocus = session.getDescriptor();
            }
            this.setChanged();
            this.notifyObservers(new Statement((Object)session, "new", null));
            return session;
        }
        log.log((IStatus)new Status(4, "org.fao.fi.fishstat.gui.core.GuiCoreRegistry", "not enough memory(20)>=" + (maxmemory - (usedmemory + requestedMemory))));
        NotEnoughMemoryException ex = new NotEnoughMemoryException();
        ex.setFreeMemory(maxmemory);
        ex.setRequestedMemory(requestedMemory);
        throw ex;
    }
}

