/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.validators;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.ValidationSourcedStatus;
import org.fao.fi.fishstat.core.model.validators.ValidAcronym;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;

public class ConceptExistenceByAcronymValidator
implements IValidator {
    private Object source;
    private String concept_acronym;

    public ConceptExistenceByAcronymValidator() {
    }

    public ConceptExistenceByAcronymValidator(String concept) {
        this.concept_acronym = concept;
    }

    public ConceptExistenceByAcronymValidator(Object source) {
        this.source = source;
    }

    public ConceptExistenceByAcronymValidator(Object source, String concept) {
        this.source = source;
        this.concept_acronym = concept;
    }

    public IStatus validate(Object value) {
        if (value instanceof String) {
            IStatus valid_acronym = new ValidAcronym(this.source).validate(value);
            if (valid_acronym.equals(Status.OK_STATUS)) {
                Concept concept = ReferenceServiceFactory.getService().getConcept(this.concept_acronym);
                String err_msg = "Undefined concept";
                return concept == null ? (this.source == null ? ValidationStatus.error((String)err_msg) : ValidationSourcedStatus.error(err_msg, this.source)) : Status.OK_STATUS;
            }
            return valid_acronym;
        }
        throw new RuntimeException("Not supposed to be called for not-String.");
    }
}

