/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.data;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class TimeSeriesImplWrapper {
    Timeseries timeseries;

    public TimeSeriesImplWrapper(Timeseries timeseries) throws TimeseriesServiceException {
        this.timeseries = timeseries;
    }

    public Timeseries getTimeseries() {
        return this.timeseries;
    }

    public void add(List<ObservationSeries> list, IProgressMonitor monitor) throws TimeseriesServiceException {
        try {
            if (list == null) {
                throw new IllegalArgumentException("Series list can not be null");
            }
            for (ObservationSeries series : list) {
                if (series == null) {
                    throw new IllegalArgumentException("Series can not be null");
                }
                if (this.timeseries.compatible(series)) continue;
                throw new IllegalArgumentException("Incompatible series");
            }
            Class c = TimeseriesServiceHelper.getTimeseriesDTOClass((String)this.timeseries.getDataset().getAcronym(), (String)this.timeseries.getAcronym());
            Constructor constructor = c.getConstructor(new Class[0]);
            GenericDAO object_dao = TimeseriesServiceHelper.getTimeseriesDAO((String)this.timeseries.getDataset().getAcronym(), (String)this.timeseries.getAcronym());
            List dimensions = this.timeseries.getDataset().getDimensions();
            Identifier id = IdentifierHelper.instance((String)object_dao.generateId());
            for (ObservationSeries series : list) {
                if (monitor != null) {
                    monitor.subTask("persisting series: " + id);
                }
                Object dto = constructor.newInstance(new Object[0]);
                Commons.setDTOIdentifier(dto, (String)id.stringValue());
                for (Dimension dimension : dimensions) {
                    Concept concept = dimension.getConcept();
                    Attribute attribute = dimension.getAttribute();
                    ReferenceObject object = (ReferenceObject)series.getKeys().asMap().get(concept);
                    Commons.setDTOAttribute(dto, (String)concept.getAcronym(), (Object)object.getAttribute(attribute), (Class)attribute.getType().getRuntimeType());
                }
                for (Map.Entry entry : series.getMeasures().entrySet()) {
                    Commons.setDTOAttribute(dto, (String)("VALUE_" + ((ObservationPeriod)entry.getKey()).toString()), (Object)((Measure)entry.getValue()).getValue(), Double.class);
                    Commons.setDTOAttribute(dto, (String)("SYMBOL_" + ((ObservationPeriod)entry.getKey()).toString()), (Object)((Measure)entry.getValue()).getStatus().toString(), String.class);
                }
                object_dao.insert(dto);
                id = IdentifierHelper.next((Identifier)id);
                if (monitor == null) continue;
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            throw new TimeseriesServiceException("Unable to add the series", (Throwable)e);
        }
    }
}

