/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.api.io.csv.impl;

import java.util.HashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.api.io.csv.DenormalisedTimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.impl.TimeseriesCSVMetadataImpl;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public class DenormalisedTimeseriesCSVMetadataImpl
extends TimeseriesCSVMetadataImpl
implements DenormalisedTimeseriesCSVMetadata {
    private Map<String, Integer> measureValueColumns;
    private Map<String, String> measureValueHeaders;
    private Map<String, Integer> measureStatusColumns;
    private Map<String, String> measureStatusHeaders;

    protected DenormalisedTimeseriesCSVMetadataImpl() {
    }

    public DenormalisedTimeseriesCSVMetadataImpl(Timeseries timeseries) {
        super(timeseries);
        this.measureValueColumns = new HashMap<String, Integer>();
        this.measureValueHeaders = new HashMap<String, String>();
        this.measureStatusColumns = new HashMap<String, Integer>();
        this.measureStatusHeaders = new HashMap<String, String>();
        for (ObservationPeriod period : timeseries.getObservationPeriods()) {
            this.measureValueHeaders.put(period.toString(), "VALUE_" + period.toString());
            this.measureValueColumns.put(period.toString(), this.columnCounter++);
            this.measureStatusHeaders.put(period.toString(), "SYMBOL_" + period.toString());
            this.measureStatusColumns.put(period.toString(), this.columnCounter++);
        }
    }

    @Override
    public int getMeasureStatusColumn(String period) {
        Integer column = this.measureStatusColumns.get(period);
        return column == null ? -1 : column;
    }

    @Override
    public String getMeasureStatusHeader(String period) {
        return this.measureStatusHeaders.get(period);
    }

    @Override
    public int getMeasureValueColumn(String period) {
        Integer column = this.measureValueColumns.get(period);
        return column == null ? -1 : column;
    }

    @Override
    public String getMeasureValueHeader(String period) {
        return this.measureValueHeaders.get(period);
    }

    @Override
    public void setMeasureStatusColumn(String period, int index) {
        this.measureStatusColumns.put(period, index);
    }

    @Override
    public void setMeasureStatusHeader(String period, String header) {
        this.measureStatusHeaders.put(period, header);
    }

    @Override
    public void setMeasureValueColumn(String period, int index) {
        this.measureValueColumns.put(period, index);
    }

    @Override
    public void setMeasureValueHeader(String period, String header) {
        this.measureValueHeaders.put(period, header);
    }
}

