/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class ObservationPeriod
implements Comparable<ObservationPeriod>,
Serializable {
    private static final ObservationPeriod YEAR_ORDINAL_MIN = new ObservationPeriod("Y1900");
    private static final long serialVersionUID = -2746505299508530023L;
    public static final String YEAR = "Y";
    public static final String QUARTER = "Q";
    public static final String MONTH = "M";
    private static final String STRICT_YEAR_REGEXP = "(Y?([0-9]{4}))";
    private static final String STRICT_QUARTER_REGEXP = "(Q([1234]))";
    private static final String STRICT_MONTH_REGEXP = "(M(([1-9])|(1[012])))";
    private static final String YEAR_REGEXP = "(Y?([0-9]{4}))";
    private static final String QUARTER_REGEXP = "(Y?([0-9]{4}))(Q([1234]))";
    private static final String MONTH_REGEXP = "(Y?([0-9]{4}))(M(([1-9])|(1[012])))";
    private static final String UNDEFINED_REGEXP = ".*";
    public static final String REGEXP = "(Y?([0-9]{4}))((Q([1234]))|(M(([1-9])|(1[012]))))?";
    private static final String YEAR_RANGE_REGEXP = "(Y?([0-9]{4})){1,}(((\\.{2})(Y?([0-9]{4})){1,})|(,(Y?([0-9]{4})){1,})?){1,}";
    private static final String QUARTER_RANGE_REGEXP = "(Y?([0-9]{4}))(Q([1234])){1,}(((\\.{2})(Y?([0-9]{4}))(Q([1234])){1,})|(,(Y?([0-9]{4}))(Q([1234])){1,})?){1,}";
    private static final String MONTH_RANGE_REGEXP = "(Y?([0-9]{4}))(M(([1-9])|(1[012]))){1,}(((\\.{2})(Y?([0-9]{4}))(M(([1-9])|(1[012]))){1,})|(,(Y?([0-9]{4}))(M(([1-9])|(1[012]))){1,})?){1,}";
    private static final String COMMA = ",";
    private static final String DOTS = "..";
    private static final Map<TimeResolution, String> resolution_patterns = new HashMap<TimeResolution, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(TimeResolution.YEAR, "(Y?([0-9]{4}))");
            this.put(TimeResolution.QUARTER, ObservationPeriod.QUARTER_REGEXP);
            this.put(TimeResolution.MONTH, ObservationPeriod.MONTH_REGEXP);
            this.put(TimeResolution.CUSTOM, ObservationPeriod.UNDEFINED_REGEXP);
        }
    };
    private String period;
    private String year;
    private String quarter;
    private String month;
    private int hashcode;

    public static ObservationPeriod valueOf(String period) {
        if (period == null) {
            throw new IllegalArgumentException("Provided period can not be null");
        }
        if (!ObservationPeriod.isValid(period)) {
            throw new IllegalArgumentException("Provided period format is not allowed, expected format: (Y?([0-9]{4}))((Q([1234]))|(M(([1-9])|(1[012]))))?");
        }
        return new ObservationPeriod(period);
    }

    public TimeResolution getResolution() {
        return this.getResolution(this.period);
    }

    private TimeResolution getResolution(String period) {
        for (TimeResolution resolution : TimeResolution.RESOLUTIONS) {
            if (!period.matches(resolution_patterns.get(resolution))) continue;
            return resolution;
        }
        return TimeResolution.CUSTOM;
    }

    public static List<ObservationPeriod> parseRange(String range, TimeResolution resolution) {
        if (range == null) {
            throw new IllegalArgumentException("Provided range can not be null");
        }
        if (resolution == null) {
            throw new IllegalArgumentException("Provided time resolution can not be null");
        }
        if (!ObservationPeriod.isValidRange(range, resolution)) {
            throw new IllegalArgumentException("Provided range is not valid");
        }
        HashSet<ObservationPeriod> periods = new HashSet<ObservationPeriod>();
        StringTokenizer comma_tokenizer = new StringTokenizer(range, COMMA);
        while (comma_tokenizer.hasMoreTokens()) {
            String subrange = comma_tokenizer.nextToken();
            int dots_index = subrange.indexOf(DOTS);
            if (dots_index == -1) {
                if (ObservationPeriod.isValid(subrange, resolution)) {
                    periods.add(ObservationPeriod.valueOf(subrange));
                    continue;
                }
                throw new IllegalArgumentException("The period range is not valid");
            }
            String from = subrange.substring(0, dots_index);
            String to = subrange.substring(dots_index + 2);
            if (ObservationPeriod.isValid(from, resolution) && ObservationPeriod.isValid(to, resolution)) {
                periods.addAll(TimeseriesServiceHelper.calculateObservationPeriods(ObservationPeriod.valueOf(from), ObservationPeriod.valueOf(to), resolution));
                continue;
            }
            throw new IllegalArgumentException("The period range is not valid");
        }
        ArrayList<ObservationPeriod> result = new ArrayList<ObservationPeriod>(periods);
        Collections.sort(result);
        return result;
    }

    public static boolean isValidRange(String range, TimeResolution resolution) {
        if (range == null) {
            throw new IllegalArgumentException("Provided range can not be null");
        }
        if (resolution == null) {
            throw new IllegalArgumentException("Provided time resolution can not be null");
        }
        if (TimeResolution.YEAR.equals(resolution)) {
            return Pattern.matches(YEAR_RANGE_REGEXP, range);
        }
        if (TimeResolution.QUARTER.equals(resolution)) {
            return Pattern.matches(QUARTER_RANGE_REGEXP, range);
        }
        if (TimeResolution.MONTH.equals(resolution)) {
            return Pattern.matches(MONTH_RANGE_REGEXP, range);
        }
        throw new UnsupportedOperationException("Time resolutuion not supported");
    }

    public ObservationPeriod(String period) {
        Matcher m;
        if (period == null) {
            throw new IllegalArgumentException("Provided period can not be null");
        }
        if (!(period = period.toUpperCase(Locale.ENGLISH)).startsWith(YEAR)) {
            period = YEAR + period;
        }
        if ((m = Pattern.compile(REGEXP).matcher(period)).matches()) {
            this.year = m.group(2);
            this.quarter = m.group(5);
            this.month = m.group(7);
        }
        this.period = period;
        this.hashcode = this.buildHashCode();
    }

    public static boolean isValid(String period) {
        return Pattern.matches(REGEXP, period);
    }

    public static boolean isValid(String period, TimeResolution resolution) {
        return Pattern.matches(resolution_patterns.get(resolution), period);
    }

    public String toString() {
        return this.period;
    }

    public String getISO8601() {
        TimeResolution resolution = this.getResolution();
        if (TimeResolution.YEAR.equals(resolution)) {
            return this.getYear();
        }
        if (TimeResolution.QUARTER.equals(resolution)) {
            int quarter = Integer.valueOf(this.getQuarter());
            int month = (quarter - 1) * 3 + 1;
            return String.valueOf(this.getYear()) + "-" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "/P3M";
        }
        if (TimeResolution.MONTH.equals(resolution)) {
            int month = Integer.valueOf(this.getMonth());
            return String.valueOf(this.getYear()) + "-" + (month < 10 ? "0" + month : Integer.valueOf(month));
        }
        return this.period;
    }

    private int buildHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.period == null ? 0 : this.period.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObservationPeriod)) {
            return false;
        }
        ObservationPeriod other = (ObservationPeriod)obj;
        return !(this.period == null ? other.period != null : !this.period.equals(other.period));
    }

    @Override
    public int compareTo(ObservationPeriod o) {
        if (o == null) {
            throw new IllegalArgumentException("Period is null");
        }
        if (!this.getResolution().equals(o.getResolution())) {
            throw new IllegalArgumentException("Period resolution incompatible");
        }
        return Integer.valueOf(this.getOrdinalNumber()).compareTo(o.getOrdinalNumber());
    }

    public String getYear() {
        return this.year;
    }

    public String getQuarter() {
        return this.quarter;
    }

    public String getMonth() {
        return this.month;
    }

    public int getOrdinalNumber() {
        int start_yr = Integer.valueOf(YEAR_ORDINAL_MIN.getYear());
        int end_yr = Integer.valueOf(this.getYear());
        int years = end_yr - start_yr;
        TimeResolution resolution = this.getResolution();
        if (TimeResolution.YEAR.equals(resolution)) {
            return years;
        }
        if (TimeResolution.QUARTER.equals(resolution)) {
            int quarter = Integer.valueOf(this.getQuarter());
            return 4 * years + quarter;
        }
        if (TimeResolution.MONTH.equals(resolution)) {
            int month = Integer.valueOf(this.getMonth());
            return 12 * years + month;
        }
        throw new UnsupportedOperationException("Time resolutuion not supported");
    }
}

