/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.ddlutils;

import java.net.URI;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.fao.fi.fishstat.data.common.api.ResourceManager;
import org.postgresql.ds.PGPoolingDataSource;

public class DdlUtilsHelper {
    private static Platform platform;
    private static Database currentModel;
    private static String databaseName;

    public static synchronized Platform getPlatform() throws Exception {
        if (platform == null) {
            if (ResourceManager.getJdbcDriver().equals("org.apache.derby.jdbc.EmbeddedDriver")) {
                databaseName = ResourceManager.getJdbcUrl().substring(11);
                EmbeddedDataSource dds = new EmbeddedDataSource();
                dds.setDatabaseName(databaseName);
                dds.setUser(ResourceManager.getJdbcUser());
                dds.setPassword(ResourceManager.getJdbcPassword());
                platform = PlatformFactory.createNewPlatformInstance((DataSource)dds);
            } else if (ResourceManager.getJdbcDriver().equals("oracle.jdbc.driver.OracleDriver")) {
                databaseName = ResourceManager.getJdbcUrl().substring(18);
                OracleDataSource ods = new OracleDataSource();
                ods.setURL(ResourceManager.getJdbcUrl());
                ods.setUser(ResourceManager.getJdbcUser());
                ods.setPassword(ResourceManager.getJdbcPassword());
                platform = PlatformFactory.createNewPlatformInstance((DataSource)ods);
            } else if (ResourceManager.getJdbcDriver().equals("org.postgresql.Driver")) {
                databaseName = ResourceManager.getJdbcUrl().substring(18);
                String cleanURI = ResourceManager.getJdbcUrl().substring(5);
                URI uri = URI.create(cleanURI);
                String host_id = uri.getHost();
                int port_number = uri.getPort();
                String db_id = uri.getPath().substring(1);
                PGPoolingDataSource dataSource = new PGPoolingDataSource();
                dataSource.setDataSourceName("Postgres");
                dataSource.setServerName(host_id);
                dataSource.setDatabaseName(db_id);
                dataSource.setPortNumber(port_number);
                dataSource.setUser(ResourceManager.getJdbcUser());
                dataSource.setPassword(ResourceManager.getJdbcPassword());
                dataSource.setMaxConnections(2);
                platform = PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
                PlatformInfo platformInfo = platform.getPlatformInfo();
                platformInfo.setMaxIdentifierLength(63);
            }
        }
        return platform;
    }

    public static synchronized Database getDatabase() throws Exception {
        if (currentModel == null) {
            currentModel = DdlUtilsHelper.getPlatform().readModelFromDatabase(databaseName);
        }
        return currentModel;
    }

    public static synchronized Database reloadDatabase() throws Exception {
        currentModel = DdlUtilsHelper.getPlatform().readModelFromDatabase(databaseName);
        return currentModel;
    }

    public static synchronized void dumpDatabase(String filename) throws Exception {
        new DatabaseIO().write(DdlUtilsHelper.getDatabase(), filename);
    }

    public static synchronized void alterDatabase(Database desiredDb) throws Exception {
        DdlUtilsHelper.getPlatform().alterTables(desiredDb, false);
    }
}

