/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroup;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.reference.api.impl.CustomGroupImpl;

public class CustomGroupFactory {
    private static Concept customGroupConcept;

    public static Concept getConcept() throws ReferenceServiceException {
        if (customGroupConcept == null) {
            customGroupConcept = ReferenceServiceFactory.getService().getConcept("CUSTOM_GROUP");
        }
        return customGroupConcept;
    }

    public static List<CustomGroup> get(Concept membersConcept) throws ReferenceServiceException {
        if (membersConcept == null) {
            throw new IllegalArgumentException("Custom group concept can not be null");
        }
        Collection<ReferenceObject> objects = CustomGroupFactory.getConcept().getObjects("MEMBERS_CONCEPT", (Object)membersConcept.getAcronym());
        ArrayList<CustomGroup> result = new ArrayList<CustomGroup>();
        for (ReferenceObject object : objects) {
            result.add(new CustomGroupImpl(object, membersConcept));
        }
        return result;
    }

    public static CustomGroup get(Identifier id) throws ReferenceServiceException {
        ReferenceObject group = CustomGroupFactory.getConcept().getObject(id);
        if (group == null) {
            return null;
        }
        Concept members_concept = ReferenceServiceFactory.getService().getConcept((String)group.getAttribute("MEMBERS_CONCEPT"));
        return new CustomGroupImpl(group, members_concept);
    }

    public static CustomGroup create(MultilingualString name, MultilingualString description, Concept membersConcept) throws ReferenceServiceException {
        if (membersConcept == null) {
            throw new IllegalArgumentException("Custom group concept can not be null");
        }
        ReferenceObject group = CustomGroupFactory.getConcept().createObject();
        group.setAttribute("NAME", (Object)name);
        group.setAttribute("DESCRIPTION", (Object)description);
        group.setAttribute("MEMBERS_CONCEPT", (Object)membersConcept.getAcronym());
        ReferenceObject added = CustomGroupFactory.getConcept().addObject(group);
        return new CustomGroupImpl(added, membersConcept);
    }

    public static void remove(Identifier id) throws ReferenceServiceException {
        ReferenceObject group = CustomGroupFactory.getConcept().getObject(id);
        CustomGroupFactory.getConcept().removeObject(group);
    }
}

