/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceServiceHelper;

public class AttributeImpl
implements Attribute {
    private Object attributeDto;
    private Identifier identifier;
    private Concept concept;
    private String acronym;
    private AttributeType type;
    private boolean codeAttribute;

    public AttributeImpl(Object attribute_dto) throws ReferenceServiceException {
        try {
            if (attribute_dto == null) {
                throw new IllegalArgumentException("Expecting not null meta attribute");
            }
            this.attributeDto = attribute_dto;
            this.identifier = IdentifierHelper.instance((String)Commons.getDTOIdentifier((Object)this.attributeDto));
            this.concept = ReferenceServiceFactory.getService().getConcept(IdentifierHelper.instance((String)((String)Commons.getDTOAttributeByAcronym((Object)this.attributeDto, (String)"CONCEPT_ID"))));
            this.acronym = (String)Commons.getDTOAttributeByAcronym((Object)this.attributeDto, (String)"ACRONYM");
            this.type = AttributeType.valueOf((String)Commons.getDTOAttributeByAcronym((Object)this.attributeDto, (String)"ATTRIBUTE_TYPE"));
            Short code = (Short)Commons.getDTOAttributeByAcronym((Object)this.attributeDto, (String)"CODE");
            this.codeAttribute = code != null && code > 0;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to instantiate the attribute", e);
        }
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public MultilingualString getDescription() throws ReferenceServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.attributeDto, (String)"DESCRIPTION");
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get description", e);
        }
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public MultilingualString getName() {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.attributeDto, (String)"NAME");
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get name", e);
        }
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public boolean isCodeAttribute() {
        return this.codeAttribute;
    }

    @Override
    public void setCodeAttribute(boolean value) throws ReferenceServiceException {
        try {
            Short dto_value = value ? (short)1 : 0;
            Commons.setDTOAttribute((Object)this.attributeDto, (String)"CODE", (Object)dto_value, Short.class);
            this.update();
            this.codeAttribute = value;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set the attribute code", e);
        }
    }

    @Override
    public void setDescription(MultilingualString description) throws ReferenceServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.attributeDto, (String)"DESCRIPTION", (MultilingualString)description);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set description", e);
        }
    }

    @Override
    public void setName(MultilingualString name) throws ReferenceServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.attributeDto, (String)"NAME", (MultilingualString)name);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set name", e);
        }
    }

    @Override
    public void setType(AttributeType type) throws ReferenceServiceException {
        try {
            Commons.setDTOAttribute((Object)this.attributeDto, (String)"ATTRIBUTE_TYPE", (Object)type.toString(), String.class);
            this.update();
            this.type = type;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set the attribute type", e);
        }
    }

    private void update() throws ReferenceServiceException {
        try {
            ReferenceServiceHelper.getRmdAttributeDao().update(Commons.getDTOPk((Object)this.attributeDto), this.attributeDto);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to update attribute: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return this.attributeDto.toString();
    }

    @Override
    public short getScale() {
        try {
            Short scale = (Short)Commons.getDTOAttributeByAcronym((Object)this.attributeDto, (String)"ATTRIBUTE_SCALE");
            return scale != null ? scale : (short)0;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get the attribute scale: " + e.getMessage(), e);
        }
    }

    @Override
    public short getSize() {
        try {
            Short size = (Short)Commons.getDTOAttributeByAcronym((Object)this.attributeDto, (String)"ATTRIBUTE_SIZE");
            return size != null ? size : (short)0;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get the attribute size: " + e.getMessage(), e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute attr = (Attribute)obj;
        if (this.getId() == null) {
            return attr.getId() == null;
        }
        return attr.getId().equals(this.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean isNameAttribute() {
        try {
            Short is_name = (Short)Commons.getDTOAttributeByAcronym((Object)this.attributeDto, (String)"NAME");
            return is_name > 0;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to update attribute: " + e.getMessage(), e);
        }
    }

    @Override
    public void setNameAttribute(boolean value) throws ReferenceServiceException {
        try {
            Short is_name = value ? (short)1 : 0;
            Commons.setDTOAttribute((Object)this.attributeDto, (String)"NAME", (Object)is_name, Short.class);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to update attribute: " + e.getMessage(), e);
        }
    }
}

