/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.management.test;

import java.util.Date;
import java.util.HashMap;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.management.ReferenceManagementServiceFactory;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.AttributeDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.ConceptDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.DescriptorsFactory;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.RelationshipDescriptor;
import org.junit.BeforeClass;
import org.junit.Test;

public class ManagementTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    private void fire() throws Exception {
        System.out.println("firing changes...");
        Commons.fire();
        System.out.println("changes fired.");
    }

    @Test
    public void preLoadTest() throws Exception {
        System.out.println("*** Preloading ***");
        for (Concept concept : ReferenceServiceFactory.getService().getConcepts()) {
            concept.getObjects();
        }
        System.out.println("*** Preloaded ***");
    }

    @Test
    public void removeConceptTest() throws Exception {
        System.out.println("*** Removing concept ***");
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        if (test != null) {
            ReferenceManagementServiceFactory.getReferenceMetadataManagementService().removeConcept(test);
            this.fire();
        }
        System.out.println("*** Concept removed ***");
    }

    @Test
    public void createConceptTest() throws Exception {
        System.out.println("*** Recreating concept ***");
        MultilingualString name = new MultilingualString();
        name.setValue("en", "Name");
        MultilingualString description = new MultilingualString();
        description.setValue("en", "Description");
        Version version = new Version("1.0.0", new Date(), " Francesco Calderini");
        ConceptDescriptor concept_descriptor = DescriptorsFactory.createConceptDescriptor("TEST", name, description, version);
        Concept test = ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createConcept(concept_descriptor);
        AttributeDescriptor name_descriptor = DescriptorsFactory.createAttributeDescriptor(test.getId(), "NAME", name, description, AttributeType.MULTILINGUAL_STRING, (short)20, (short)0, false, true);
        ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createAttribute(name_descriptor);
        AttributeDescriptor code_descriptor = DescriptorsFactory.createAttributeDescriptor(test.getId(), "CODE", name, description, AttributeType.STRING, (short)10, (short)0, true, false);
        ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createAttribute(code_descriptor);
        this.fire();
        System.out.println("*** Concept created ***");
    }

    @Test
    public void createInitialObjects() throws Exception {
        System.out.println("*** Creating initial object ***");
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        MultilingualString name = new MultilingualString();
        HashMap<Attribute, Object> attributes = new HashMap<Attribute, Object>();
        name.setValue("en", "Parent object");
        attributes.put(test.getAttribute("NAME"), name);
        attributes.put(test.getAttribute("CODE"), "101");
        ReferenceObject object = test.createObject(attributes);
        System.out.println(object.toString());
        test.addObject(object);
        System.out.println("*** Initial object created ***");
    }

    @Test
    public void addAddressAttributeTest() throws Exception {
        System.out.println("*** Adding attribute ***");
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        System.out.println("*** attributes before ***");
        for (Attribute attribute : test.getAttributes()) {
            System.out.println(attribute);
        }
        MultilingualString name = new MultilingualString();
        name.setValue("en", "Address");
        MultilingualString description = new MultilingualString();
        description.setValue("en", "Address");
        AttributeDescriptor attribute_descriptor = DescriptorsFactory.createAttributeDescriptor(test.getId(), "ADDRESS", name, description, AttributeType.STRING, (short)20, (short)0, false, false);
        ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createAttribute(attribute_descriptor);
        System.out.println("*** attributes after ***");
        for (Attribute attribute : test.getAttributes()) {
            System.out.println(attribute);
        }
        this.fire();
        System.out.println("*** Attribute added ***");
    }

    @Test
    public void createAdditionalObjects() throws Exception {
        System.out.println("*** Creating additional objects ***");
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        for (ReferenceObject obj : test.getObjects()) {
            System.out.println(obj);
        }
        MultilingualString name = new MultilingualString();
        HashMap<Attribute, Object> attributes = new HashMap<Attribute, Object>();
        name.setValue("en", "First child object");
        attributes.put(test.getAttribute("NAME"), name);
        attributes.put(test.getAttribute("CODE"), "102");
        attributes.put(test.getAttribute("ADDRESS"), "Via Fedone 1");
        ReferenceObject object = test.createObject(attributes);
        System.out.println(object.toString());
        test.addObject(object);
        name.setValue("en", "Second child object");
        attributes.put(test.getAttribute("NAME"), name);
        attributes.put(test.getAttribute("CODE"), "103");
        attributes.put(test.getAttribute("ADDRESS"), "Via Fedone 1");
        object = test.createObject(attributes);
        System.out.println(object.toString());
        test.addObject(object);
        System.out.println("*** Additional objects created ***");
    }

    @Test
    public void removeAddressAttributeTest() throws Exception {
        System.out.println("*** Removing attribute ***");
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        Attribute address = test.getAttribute("ADDRESS");
        ReferenceManagementServiceFactory.getReferenceMetadataManagementService().removeAttribute(address);
        this.fire();
        System.out.println("*** Attribute removed ***");
    }

    @Test
    public void createRelationship() throws Exception {
        System.out.println("*** Creating relationship ***");
        MultilingualString name = new MultilingualString();
        name.setValue("en", "Test relationship");
        MultilingualString description = new MultilingualString();
        description.setValue("en", "Test relationship");
        Version version = new Version("1.0.0", new Date(), " Francesco Calderini");
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        RelationshipDescriptor descriptor = DescriptorsFactory.createRelationshipDescriptor("TEST_TEST", name, description, test.getId(), test.getId(), version, 1);
        ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createRelationship(descriptor);
        this.fire();
        System.out.println("*** Relationship created ***");
    }

    @Test
    public void createRelationshipInstance() throws Exception {
        System.out.println("*** Creating relationship instances ***");
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        for (ReferenceObject obj : test.getObjects()) {
            System.out.println(obj);
        }
        ReferenceObject parent = test.getObject("CODE", (Object)"101");
        System.out.println(parent.toString());
        ReferenceObject first_child = test.getObject("CODE", (Object)"102");
        System.out.println(first_child.toString());
        ReferenceObject second_child = test.getObject("CODE", (Object)"103");
        System.out.println(second_child.toString());
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("TEST_TEST");
        relationship.add(parent, first_child);
        relationship.add(parent, second_child);
        System.out.println("*** Relationship instances created ***");
    }

    @Test
    public void forcedFireTest() throws Exception {
        RegistryFactory.getRegistry((Object)ReferenceServiceFactory.getService().getConcept("SPECIES")).fireStructuralChangeEvent(StructuralChangeEvent.REFERENCE_OBJECT_CHANGE);
    }
}

