/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.export.impl;

import org.fao.fi.fishstat.export.CellDecorator;
import org.fao.fi.fishstat.export.ExportDecorators;

public class ExportDecoratorsImpl
implements ExportDecorators {
    private CellDecorator[] keysDecorators;
    private CellDecorator[] measDecorators;
    private CellDecorator[] calcDecorators;

    public ExportDecoratorsImpl(int keysSize, int measSize, int calcSize) {
        this.keysDecorators = new CellDecorator[keysSize];
        this.measDecorators = new CellDecorator[measSize];
        this.calcDecorators = new CellDecorator[calcSize];
    }

    @Override
    public CellDecorator getDecorator(int group, int idx) {
        CellDecorator[] target = this.identifyTarget(group);
        return target[idx];
    }

    @Override
    public void setDecorator(int group, int idx, CellDecorator decorator) {
        CellDecorator[] target = this.identifyTarget(group);
        target[idx] = decorator;
    }

    @Override
    public void setDecorationValues(int group, int idx, String backgroundColor, String foregroundColor) {
        CellDecorator[] target = this.identifyTarget(group);
        if (target[idx] == null) {
            target[idx] = new CellDecorator(backgroundColor, foregroundColor);
        }
    }

    private CellDecorator[] identifyTarget(int group) {
        switch (group) {
            case 1: {
                return this.keysDecorators;
            }
            case 2: {
                return this.measDecorators;
            }
            case 3: {
                return this.calcDecorators;
            }
        }
        return null;
    }
}

