/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.ResourceManager;
import org.fao.fi.fishstat.data.common.api.exceptions.ReflectionException;
import org.fao.fi.fishstat.data.common.classloader.ClassLoaderFactory;
import org.fao.fi.fishstat.data.common.firestorm.FireStormHelper;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;

public class Commons {
    public static final String TMP_DIR = System.getProperty("java.io.tmpdir").endsWith(File.separator) ? System.getProperty("java.io.tmpdir") : String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator;
    public static final String SCHEMA = "FISHSTAT";
    public static final String ID_ATTRIBUTE_ACRONYM = "ID";
    public static final String ACRONYM_ATTRIBUTE = "ACRONYM";
    public static final String NAME_ATTRIBUTE = "NAME";
    public static final String DESCRIPTION_ATTRIBUTE = "DESCRIPTION";
    public static final String VERSION_NUMBER_ATTRIBUTE = "V_NUMBER";
    public static final String VERSION_DATE_ATTRIBUTE = "V_DATE";
    public static final String VERSION_AUTHOR_ATTRIBUTE = "V_AUTHOR";
    public static final int ID_ATTRIBUTE_SIZE = 20;
    public static final String INDEX_SUFFIX = "_IDX";
    public static final String UNIQUE_PREFIX = "UNQ_";
    public static final String GENERATED_PACKAGE = "org.fao.fi.fishstat.data.generated.";
    public static final String DAO_PACKAGE = "org.fao.fi.fishstat.data.generated.dao.";
    public static final String FACTORY_PACKAGE = "org.fao.fi.fishstat.data.generated.factory.";
    public static final String DTO_PACKAGE = "org.fao.fi.fishstat.data.generated.dto.";
    public static final String JDBC_PACKAGE = "org.fao.fi.fishstat.data.generated.jdbc.";
    public static final String DAO_CLASSNAME_SUFFIX = "Dao";
    public static final String FACTORY_CLASSNAME_SUFFIX = "DaoFactory";
    public static final String CREATE_DAO_METHOD = "create";
    public static final String GET_METHOD_PREFIX = "get";
    public static final String SET_METHOD_PREFIX = "set";
    public static final String ACRONYM_DELIMITER = "_";
    public static final String SCHEMA_DELIMITER = ".";
    public static final String CREATE_DTO_PK_METHOD = "createPk";
    private static final String GET_ID_METHOD = "getId";
    private static Map<String, Map<String, Method>> methods;
    private static Map<String, String> javaNames;
    private static Object _methodsLock;

    static {
        javaNames = Collections.synchronizedMap(new HashMap());
        _methodsLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, Method>> getMethodsMap() {
        Object object = _methodsLock;
        synchronized (object) {
            if (methods == null) {
                methods = Collections.synchronizedMap(new HashMap());
            }
            return methods;
        }
    }

    private static Method getChachedMethod(Class<?> theClass, String theMethod) throws Exception {
        Method method;
        String class_string = Integer.toHexString(theClass.hashCode());
        Map<String, Method> class_methods = Commons.getMethodsMap().get(class_string);
        if (class_methods == null) {
            class_methods = new HashMap<String, Method>();
            Commons.getMethodsMap().put(class_string, class_methods);
        }
        if ((method = class_methods.get(theMethod)) == null) {
            method = theClass.getMethod(theMethod, new Class[0]);
            class_methods.put(theMethod, method);
        }
        return method;
    }

    private static Method getMethod(Class<?> theClass, String theMethod) throws Exception {
        return Commons.getChachedMethod(theClass, theMethod);
    }

    public static final String getJavaName(String acronym) {
        String name = javaNames.get(acronym);
        if (name == null) {
            StringBuffer buffer = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(acronym, ACRONYM_DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String initial = token.substring(0, 1).toUpperCase(Locale.ENGLISH);
                String rest = token.substring(1).toLowerCase(Locale.ENGLISH);
                buffer.append(initial).append(rest);
            }
            name = buffer.toString();
            javaNames.put(acronym, name);
        }
        return name;
    }

    public static Object getDTOPk(Object dto) throws ReflectionException {
        block3: {
            try {
                if (dto != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }
        Method get_pk = Commons.getMethod(dto.getClass(), CREATE_DTO_PK_METHOD);
        Object dto_pk = get_pk.invoke(dto, new Object[0]);
        return dto_pk;
    }

    public static Object getDTOAttributeByAcronym(Object dto, String acronym) throws ReflectionException {
        block3: {
            try {
                if (dto != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }
        Method method = Commons.getMethod(dto.getClass(), GET_METHOD_PREFIX + Commons.getJavaName(acronym));
        Object value = method.invoke(dto, new Object[0]);
        return value;
    }

    public static Object getDTOAttributeByMethodName(Object dto, String methodName) throws ReflectionException {
        block3: {
            try {
                if (dto != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }
        Method method = Commons.getMethod(dto.getClass(), methodName);
        Object value = method.invoke(dto, new Object[0]);
        return value;
    }

    public static String getDTOIdentifier(Object dto) throws ReflectionException {
        return (String)Commons.getDTOAttributeByMethodName(dto, GET_ID_METHOD);
    }

    /*
     * Unable to fully structure code
     */
    public static void setDTOAttribute(Object dto, String acronym, Object value, Class<?> clazz) throws ReflectionException {
        block4: {
            try {
                method = dto.getClass().getMethod("set" + Commons.getJavaName(acronym), new Class[]{clazz});
                method.invoke(dto, new Object[]{value});
                break block4;
            }
            catch (Exception e) {
                System.out.println("ERROR " + e.getMessage());
                System.out.println("failed to locate set" + Commons.getJavaName(acronym) + "(" + clazz.getName() + ")");
                System.out.println("invoked with " + value.getClass().getName());
                ma = dto.getClass().getDeclaredMethods();
                i = 0;
                ** while (i < ma.length)
            }
lbl-1000:
            // 1 sources

            {
                m = ma[i];
                pType = m.getParameterTypes();
                pTypeStr = " ";
                if (pType.length == 1) {
                    pTypeStr = pType[0].getName();
                }
                System.out.println(String.valueOf(i) + " " + m.getReturnType() + " " + m.getName() + "(" + pTypeStr + ")");
                ++i;
                continue;
            }
lbl21:
            // 1 sources

            throw new ReflectionException(e);
        }
    }

    public static void setMultilingualDTOAttribute(Object dto, String acronym, MultilingualString multistring) throws ReflectionException {
        if (multistring != null) {
            for (String language : MultilingualString.LANGUAGES) {
                String language_string = multistring.getValue(language);
                Commons.setDTOAttribute(dto, String.valueOf(acronym) + ACRONYM_DELIMITER + language, language_string, String.class);
            }
        }
    }

    public static MultilingualString getMultilingualDTOAttribute(Object dto, String acronym) throws ReflectionException {
        MultilingualString multistring = new MultilingualString();
        for (String language : MultilingualString.LANGUAGES) {
            String language_string = (String)Commons.getDTOAttributeByAcronym(dto, String.valueOf(acronym) + ACRONYM_DELIMITER + language);
            multistring.setValue(language, language_string);
        }
        return multistring;
    }

    public static void setDTOIdentifier(Object dto, String id) throws ReflectionException {
        Commons.setDTOAttribute(dto, ID_ATTRIBUTE_ACRONYM, id, String.class);
    }

    public static void fireClassLoaderLoad() {
        ClassLoaderFactory.setClassLoader(ResourceManager.getJdbcDaoJarUrl());
    }

    public static void fireJdbcDaoGeneration() throws Exception {
        FireStormHelper.instance().generateJdbcDAO();
    }

    public static void fireJdbcDaoCompilation() throws Exception {
        FireStormHelper.instance().compileJdbcDAO();
    }

    public static void fireJdbcDaoBuild() throws Exception {
        FireStormHelper.instance().buildJdbcDAOJar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireMethodsMapReset() {
        Object object = _methodsLock;
        synchronized (object) {
            if (methods != null) {
                for (Map<String, Method> map : methods.values()) {
                    map.clear();
                }
                methods.clear();
                methods = null;
            }
            javaNames.clear();
        }
    }

    public static void fire() throws Exception {
        Commons.fireJdbcDaoGeneration();
        Commons.fireJdbcDaoCompilation();
        Commons.fireJdbcDaoBuild();
        Commons.fireClassLoaderLoad();
        Commons.fireMethodsMapReset();
        RegistryFactory.fireStructuralChangeEvents();
    }
}

