/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.api.workspace;

import java.net.URL;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.ResourceManager;
import org.fao.fi.fishstat.data.common.api.workspace.Workspace;
import org.fao.fi.fishstat.data.common.api.workspace.impl.WorkspaceImpl;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;

public class WorkspaceManager {
    private static WorkspaceManager instance;
    private Workspace active;

    public static WorkspaceManager instance() {
        if (instance == null) {
            instance = new WorkspaceManager();
        }
        return instance;
    }

    public void setActiveWorkspace(Workspace workspace) throws Exception {
        this.active = workspace;
        ResourceManager.setJdbcUrl(this.active.getJdbcUrl());
        ResourceManager.setJdbcDaoJarUrl(this.active.getJarUrl().toString());
        Commons.fireMethodsMapReset();
        Commons.fireClassLoaderLoad();
        RegistryFactory.fireStructuralChangeEvent(StructuralChangeEvent.WORKSPACE_CHANGE);
    }

    public Workspace getActiveWorkspace() {
        return this.active;
    }

    public Workspace createWorkspace(String jdbcUrl, URL jdbcDaoJarUrl) {
        return new WorkspaceImpl(jdbcUrl, jdbcDaoJarUrl);
    }
}

