/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.classloader;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.jar.JarFile;
import org.fao.fi.fishstat.data.common.api.ResourceManager;

public class ClassLoaderFactory {
    private static ClassLoader loader;

    public static ClassLoader getClassLoader() {
        if (loader == null) {
            ClassLoaderFactory.setClassLoader(ResourceManager.getJdbcDaoJarUrl());
        }
        return loader;
    }

    public static void dispose() {
        try {
            Class<URLClassLoader> clazz = URLClassLoader.class;
            Field ucp = clazz.getDeclaredField("ucp");
            ucp.setAccessible(true);
            Object sun_misc_URLClassPath = ucp.get(loader);
            Field loaders = sun_misc_URLClassPath.getClass().getDeclaredField("loaders");
            loaders.setAccessible(true);
            Object java_util_Collection = loaders.get(sun_misc_URLClassPath);
            Object[] objectArray = ((Collection)java_util_Collection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object sun_misc_URLClassPath_JarLoader = objectArray[n2];
                try {
                    Field loader_field = sun_misc_URLClassPath_JarLoader.getClass().getDeclaredField("jar");
                    loader_field.setAccessible(true);
                    Object java_util_jar_JarFile = loader_field.get(sun_misc_URLClassPath_JarLoader);
                    ((JarFile)java_util_jar_JarFile).close();
                    System.out.println("Workspace-DAO file closed: " + ((JarFile)java_util_jar_JarFile).getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        loader = null;
    }

    public static void setClassLoader(String jdbcDaoJARpath) {
        try {
            URL jdbc_dao_url = new URL(jdbcDaoJARpath);
            URL[] urls = new URL[]{jdbc_dao_url};
            System.out.println("loading jar: " + jdbc_dao_url);
            loader = JdbcClassLoader.newInstance(urls, ClassLoaderFactory.class.getClassLoader());
            System.out.println("JDBC-DAO classloader: " + loader.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class JdbcClassLoader
    extends URLClassLoader {
        public static JdbcClassLoader newInstance(final URL[] urls) {
            JdbcClassLoader result = AccessController.doPrivileged(new PrivilegedAction<JdbcClassLoader>(){

                @Override
                public JdbcClassLoader run() {
                    return new JdbcClassLoader(urls);
                }
            });
            return result;
        }

        public static JdbcClassLoader newInstance(final URL[] urls, final ClassLoader parent) {
            JdbcClassLoader result = AccessController.doPrivileged(new PrivilegedAction<JdbcClassLoader>(){

                @Override
                public JdbcClassLoader run() {
                    return new JdbcClassLoader(urls, parent);
                }
            });
            return result;
        }

        public JdbcClassLoader(URL[] urls) {
            super(urls);
        }

        public JdbcClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> result = null;
            if (!name.startsWith("org.fao.fi.fishstat.data.generated.")) {
                result = super.loadClass(name, true);
            } else {
                result = this.findLoadedClass(name);
                if (result == null) {
                    result = this.findClass(name);
                    this.resolveClass(result);
                }
            }
            return result;
        }
    }
}

