/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import java.beans.Beans;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.model.functions.ParameterWrapper;

public class FunctionParameterEditor
extends Composite
implements Observer {
    private String lang = null;
    private ParameterWrapper parameterWrapper;
    private Label lblName;
    private Text text;
    private CCombo combo;
    private Label lblInvalidParameter;

    public FunctionParameterEditor(Composite parent, int style, ParameterWrapper parameterWrapper, String lang) {
        super(parent, 0);
        this.setBackground(SWTResourceManager.getColor(1));
        this.setBackgroundMode(2);
        this.lang = lang;
        this.parameterWrapper = parameterWrapper;
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginRight = 1;
        gridLayout.marginLeft = 1;
        gridLayout.marginTop = 1;
        gridLayout.marginBottom = 1;
        gridLayout.horizontalSpacing = 2;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 1;
        this.setLayout((Layout)gridLayout);
        this.lblName = new Label((Composite)this, 0);
        this.lblName.setBackground(SWTResourceManager.getColor(1));
        this.lblName.setForeground(ComponentsCommons.getColor(0, 0, 102));
        this.lblName.setFont(ComponentsCommons.getFont("Tahoma", 8, 0));
        GridData gridData = new GridData(4, 4, false, true, 1, 1);
        gridData.widthHint = 120;
        this.lblName.setLayoutData((Object)gridData);
        new Label((Composite)this, 0);
        if (!Beans.isDesignTime()) {
            this.lblName.setText(CoreUtils.getCurrentLang((MultilingualString)this.parameterWrapper.getParameter().getName(), (String)this.lang));
            if (this.parameterWrapper.hasEnumeratedValues()) {
                this.combo = this.createCombo(this.parameterWrapper);
                this.combo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            } else {
                this.text = new Text((Composite)this, 2048);
                this.text.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                this.text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        FunctionParameterEditor.this.parameterWrapper.setValue(FunctionParameterEditor.this.text.getText());
                    }
                });
                this.lblInvalidParameter = new Label((Composite)this, 0);
                this.lblInvalidParameter.setForeground(SWTResourceManager.getColor(165, 42, 42));
                this.lblInvalidParameter.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
                this.lblInvalidParameter.setText("Invalid parameter");
            }
        }
        this.parameterWrapper.addObserver((Observer)this);
        this.renderPanel();
        this.parameterWrapper.notifyObservers();
    }

    protected void checkSubclass() {
    }

    private CCombo createCombo(ParameterWrapper pw) {
        CCombo result = new CCombo((Composite)this, 2056);
        result.setBackground(ComponentsCommons.getColor(255, 255, 255));
        for (String string : pw.getEnumeratedValues()) {
            result.add(string);
        }
        result.select(0);
        return result;
    }

    private void renderPanel() {
        if (this.parameterWrapper.isValid()) {
            if (this.text != null) {
                this.text.setBackground(SWTResourceManager.getColor(255, 255, 255));
                this.lblInvalidParameter.setVisible(false);
            }
        } else if (this.text != null) {
            this.text.setBackground(SWTResourceManager.getColor(255, 245, 238));
            this.lblInvalidParameter.setVisible(true);
        }
    }

    public void syncroPanel() {
        if (this.parameterWrapper.hasEnumeratedValues()) {
            if (this.parameterWrapper.hasValue()) {
                this.combo.select(this.parameterWrapper.getEnumeratedValues().indexOf(this.parameterWrapper.getValue()));
            }
        } else if (this.parameterWrapper.hasValue()) {
            this.text.setText(this.parameterWrapper.getValue());
        }
    }

    public void applyData() {
        if (this.parameterWrapper.hasEnumeratedValues()) {
            this.parameterWrapper.setValue(this.combo.getItem(this.combo.getSelectionIndex()));
        } else {
            this.parameterWrapper.setValue(this.text.getText());
        }
    }

    public ParameterWrapper getParameterWrapper() {
        return this.parameterWrapper;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof ParameterWrapper) {
            this.renderPanel();
        }
    }
}

