/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import java.beans.Beans;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fao.fi.fishstat.core.CoreCache;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.IReferenceObjectProcessor;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.model.concept.selection.ParentRelationSelection;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.menus.MenusUtils;
import org.fao.fi.fishstat.gui.components.widgets.DimensionRelationsComboViewer;
import org.fao.fi.fishstat.gui.components.widgets.WidgetsUtils;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;

public class ParentSelector
extends Composite
implements Observer {
    private Hashtable<String, ConceptProperties> displayProps;
    public static final int BUTTONS_STYLE = 1;
    public static final int TEXTUAL_STYLE = 2;
    private static final Color highlight_color = new Color((Device)Display.getDefault(), 255, 200, 200);
    private static final String LEFT_COLUMN = "left_column";
    private static final String CENTER_COLUMN = "center_column";
    private static final String RIGTH_COLUMN = "right_column";
    private static final String[] columnNames = new String[]{"left_column", "center_column", "right_column"};
    private int style;
    private String lang;
    private ParentRelationSelection parentRelation;
    private Relationship relationship;
    private DimensionRelationsComboViewer cmbRelationship = null;
    private ConceptSelection dimensionSelection;
    private IReferenceObjectProcessor processor;
    private Combo cmbmetarels;
    private Table table;
    private TableColumn rigth_column;
    private TableColumn center_column;
    private TableColumn left_column;
    private TableViewer tableViewer;
    private Button[] buttons_left = null;
    private Button[] buttons_center = null;
    private Button[] buttons_right = null;
    private TableEditor[] editors_left = null;
    private TableEditor[] editors_center = null;
    private TableEditor[] editors_rigth = null;
    private FormToolkit toolkit = new FormToolkit(Display.getCurrent());

    public ParentSelector(Composite parent, int style, ParentRelationSelection sel, ConceptSelection ds, DimensionProperties properties, String lang) {
        super(parent, 0);
        this.lang = lang;
        this.style = style;
        this.displayProps = new Hashtable(properties.getSelectors().size());
        for (ConceptProperties cdp : properties.getSelectors()) {
            this.displayProps.put(cdp.getConceptAcronym(), cdp);
        }
        this.setBackground(ComponentsCommons.getColor(1));
        properties.addObserver((Observer)this);
        this.parentRelation = sel;
        if (ds != null) {
            this.dimensionSelection = ds;
            this.dimensionSelection.addObserver((Observer)this);
        }
        this.dimensionSelection = ds;
        try {
            this.initComponents();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.createCombo(this);
        this.createTableViewer();
        if (!Beans.isDesignTime()) {
            Concept concept = this.cmbRelationship.getSelectedRelation().getParentConcept();
            MenusUtils.createRigthClickMenu(concept, (Control)this.tableViewer.getTable(), this.displayProps.get(concept.getAcronym()).getDimensionProperties(), this.lang);
        }
    }

    private void createCombo(Composite c) {
        this.cmbRelationship = new DimensionRelationsComboViewer(this, 8, this.parentRelation.getDimension(), this.lang);
        this.cmbRelationship.setInput(this.parentRelation);
        this.cmbmetarels = this.cmbRelationship.getCombo();
        this.cmbmetarels.setBackground(ComponentsCommons.getColor(245, 245, 245));
        GridData gd_cmbmetarels = new GridData(4, 0x1000000, true, false);
        gd_cmbmetarels.widthHint = 197;
        this.cmbmetarels.setLayoutData((Object)gd_cmbmetarels);
        this.toolkit.setBorderStyle(2048);
        this.toolkit.setBackground(ComponentsCommons.getColor(245, 245, 245));
        this.toolkit.adapt((Control)this.cmbmetarels, true, true);
        this.cmbRelationship.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BusyIndicator.showWhile((Display)ParentSelector.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ParentSelector.this.clearTableButtons();
                        Relationship relationship = ParentSelector.this.cmbRelationship.getSelectedRelation();
                        ParentSelector.this.parentRelation.setSelectedRelationship(relationship);
                        ParentSelector.this.tableViewer.setInput((Object)ParentSelector.this.parentRelation.getSelectedRelationship());
                        ParentSelector.this.tableViewer.getTable().setVisible(true);
                        if (!Beans.isDesignTime()) {
                            Concept concept = relationship.getParentConcept();
                            MenusUtils.createRigthClickMenu(concept, (Control)ParentSelector.this.tableViewer.getTable(), ((ConceptProperties)ParentSelector.this.displayProps.get(concept.getAcronym())).getDimensionProperties(), ParentSelector.this.lang);
                        }
                        ParentSelector.this.adaptTable();
                    }
                });
            }
        });
        if (this.cmbmetarels.getItemCount() > 0) {
            this.cmbmetarels.select(0);
            this.parentRelation.setSelectedRelationship(this.cmbRelationship.getSelectedRelation());
        } else {
            this.cmbmetarels.add("No relations defined");
            this.cmbmetarels.select(0);
            this.cmbmetarels.setEnabled(false);
        }
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer((Composite)this, 32768);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new ParentsRelationContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ParentsTableLabelProvider());
        this.tableViewer.setComparator((ViewerComparator)new ParentSelectorTableComparator());
        this.tableViewer.setColumnProperties(columnNames);
        this.table = this.tableViewer.getTable();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int row = WidgetsUtils.getTableRowCell(ParentSelector.this.table, e);
                ReferenceObject ro = null;
                if (row >= 0) {
                    ro = (ReferenceObject)ParentSelector.this.tableViewer.getElementAt(row);
                }
                ParentSelector.this.table.setData("lastRigthClick", ro);
            }
        });
        this.table.setBackgroundMode(2);
        this.table.setBackground(ComponentsCommons.getColor(245, 245, 245));
        this.table.setFont(ComponentsCommons.getFont("Tahoma", 8, 1));
        this.table.setLinesVisible(true);
        this.table.setForeground(ComponentsCommons.getColor(0, 0, 128));
        GridData gd_table_1 = new GridData(4, 4, true, true);
        gd_table_1.widthHint = 216;
        gd_table_1.heightHint = 219;
        this.table.setLayoutData((Object)gd_table_1);
        this.left_column = new TableColumn(this.table, 0);
        this.left_column.setWidth(25);
        this.center_column = new TableColumn(this.table, 0);
        this.center_column.setWidth(180);
        this.rigth_column = new TableColumn(this.table, 0);
        this.rigth_column.setWidth(25);
        if (this.style == 2) {
            this.table.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle clientArea = ParentSelector.this.table.getClientArea();
                    Point pt = new Point(event.x, event.y);
                    int index = ParentSelector.this.table.getTopIndex();
                    while (index < ParentSelector.this.table.getItemCount()) {
                        boolean visible = false;
                        TableItem item = ParentSelector.this.table.getItem(index);
                        int i = 0;
                        while (i < columnNames.length) {
                            Rectangle rect = item.getBounds(i);
                            if (rect.contains(pt)) {
                                ParentSelector.this.table.deselect(index);
                                if (i == 0) {
                                    ParentSelector.this.processSelection(index, "include");
                                } else if (i == 1) {
                                    ParentSelector.this.processSelection(index, "both");
                                } else if (i == 2) {
                                    ParentSelector.this.processSelection(index, "exclude");
                                }
                            }
                            if (!visible && rect.intersects(clientArea)) {
                                visible = true;
                            }
                            ++i;
                        }
                        if (!visible) {
                            return;
                        }
                        ++index;
                    }
                }
            });
        }
        this.toolkit.adapt((Control)this.table, true, true);
        GridData gd_table = new GridData(4, 4, true, true);
        gd_table.widthHint = 253;
        this.table.setLayoutData((Object)gd_table);
        this.toolkit.adapt((Control)this.table, true, true);
        if (this.parentRelation.hasSelectedRelationship()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ParentSelector.this.tableViewer.getTable().isDisposed()) {
                        ParentSelector.this.tableViewer.setInput((Object)ParentSelector.this.parentRelation.getSelectedRelationship());
                    }
                }
            });
        }
        this.adaptTable();
    }

    public ConceptProperties getSelectedConceptDisplayProperties(String acronym) {
        return this.displayProps.get(acronym);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.table;
    }

    public IReferenceObjectProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(IReferenceObjectProcessor processor) {
        this.processor = processor;
    }

    private void clearTableButtons() {
        this.table.setVisible(false);
        if (this.style == 1) {
            int i = 0;
            while (i < this.buttons_left.length) {
                this.buttons_left[i].setVisible(false);
                this.buttons_center[i].setVisible(false);
                this.buttons_right[i].setVisible(false);
                ++i;
            }
        }
        this.table.setVisible(true);
    }

    public ConceptSelection getDimensionSelection() {
        return this.dimensionSelection;
    }

    private void adaptTable() {
        int size = this.table.getItemCount();
        if (size < 20) {
            this.center_column.setWidth(198);
        } else {
            this.center_column.setWidth(185);
        }
        if (this.style == 1) {
            this.buttons_left = new Button[size];
            this.buttons_center = new Button[size];
            this.buttons_right = new Button[size];
            this.editors_left = new TableEditor[size];
            this.editors_center = new TableEditor[size];
            this.editors_rigth = new TableEditor[size];
            int i = 0;
            while (i < size) {
                TableItem item = this.table.getItem(i);
                final Integer ii = new Integer(i);
                this.buttons_left[i] = new Button((Composite)this.table, 16388);
                this.buttons_left[i].computeSize(-1, this.table.getItemHeight());
                this.buttons_left[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ParentSelector.this.processSelection(ii, "include");
                    }
                });
                this.buttons_center[i] = new Button((Composite)this.table, 0);
                this.buttons_center[i].computeSize(-1, this.table.getItemHeight());
                ReferenceObject ro = (ReferenceObject)this.tableViewer.getElementAt(i);
                try {
                    ConceptProperties cdp = this.displayProps.get(this.parentRelation.getSelectedRelationship().getChildConcept().getAcronym());
                    String label = CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)cdp.getAttribute(), (String)this.lang);
                    if ((label == null || label.trim().equals("") || label.trim().equals("...")) && cdp.hasAlternate()) {
                        label = CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)cdp.getAlternate(), (String)this.lang);
                    }
                    this.buttons_center[i].setText(label);
                }
                catch (ReferenceServiceException e) {
                    ComponentsCommons.showExceptionWithStack(e);
                }
                this.buttons_center[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ParentSelector.this.processSelection(ii, "both");
                    }
                });
                this.buttons_right[i] = new Button((Composite)this.table, 131076);
                this.buttons_right[i].computeSize(-1, this.table.getItemHeight());
                this.buttons_right[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ParentSelector.this.processSelection(ii, "exclude");
                    }
                });
                this.editors_left[i] = new TableEditor(this.table);
                this.editors_left[i].grabHorizontal = true;
                this.editors_left[i].minimumHeight = this.buttons_left[i].getSize().y;
                this.editors_left[i].minimumWidth = this.buttons_left[i].getSize().x;
                this.editors_left[i].setEditor((Control)this.buttons_left[i], item, 0);
                this.editors_center[i] = new TableEditor(this.table);
                this.editors_center[i].grabHorizontal = true;
                this.editors_center[i].minimumHeight = this.buttons_center[i].getSize().y;
                this.editors_center[i].minimumWidth = this.buttons_center[i].getSize().x;
                this.editors_center[i].setEditor((Control)this.buttons_center[i], item, 1);
                this.editors_rigth[i] = new TableEditor(this.table);
                this.editors_rigth[i].grabHorizontal = true;
                this.editors_rigth[i].minimumHeight = this.buttons_right[i].getSize().y;
                this.editors_rigth[i].minimumWidth = this.buttons_right[i].getSize().x;
                this.editors_rigth[i].setEditor((Control)this.buttons_right[i], item, 2);
                int coverage = this.getCoverage((ReferenceObject)this.tableViewer.getElementAt(i));
                this.buttons_left[i].setEnabled(coverage >= 0);
                this.buttons_right[i].setEnabled(coverage >= 0);
                ++i;
            }
        }
    }

    private void processSelection(int index, String type) {
        if (this.processor != null) {
            ReferenceObject ro = (ReferenceObject)this.tableViewer.getElementAt(index);
            this.processor.processReferenceObject(ro, (Object)type);
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item;
                item.setBackground(1, (item = tableItemArray[n2]) == this.table.getItem(index) ? highlight_color : this.table.getBackground());
                ++n2;
            }
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    private int getCoverage(ReferenceObject ro) {
        return CoreUtils.getCoverage((Relationship)this.relationship, (ReferenceObject)ro, this.dimensionSelection != null ? this.dimensionSelection.getAll() : null);
    }

    class ParentSelectorTableComparator
    extends ViewerComparator {
        ParentSelectorTableComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            try {
                String s1 = CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)e1), (Attribute)((ConceptProperties)ParentSelector.this.displayProps.get(ParentSelector.this.parentRelation.getSelectedRelationship().getParentConcept().getAcronym())).getAttribute(), (String)ParentSelector.this.lang);
                String s2 = CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)e2), (Attribute)((ConceptProperties)ParentSelector.this.displayProps.get(ParentSelector.this.parentRelation.getSelectedRelationship().getParentConcept().getAcronym())).getAttribute(), (String)ParentSelector.this.lang);
                int res = super.compare(viewer, (Object)s1, (Object)s2);
                return res;
            }
            catch (Exception e) {
                return 0;
            }
        }

        public void sort(Viewer viewer, Object[] elements) {
            super.sort(viewer, elements);
        }
    }

    public class ParentsRelationContentProvider
    implements IStructuredContentProvider,
    Observer {
        private StructuredViewer viewer;

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Relationship) {
                ParentSelector.this.relationship = (Relationship)inputElement;
                Set parents = ParentSelector.this.relationship.getParents();
                if (parents != null && parents.size() > 0) {
                    return parents.toArray(new ReferenceObject[0]);
                }
                return new ReferenceObject[0];
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (viewer instanceof StructuredViewer) {
                this.viewer = (StructuredViewer)viewer;
            }
            if (newInput instanceof ParentRelationSelection) {
                ((ParentRelationSelection)newInput).addObserver((Observer)this);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            this.viewer.refresh(true);
        }
    }

    public class ParentsTableLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (ParentSelector.this.style == 2 && columnIndex == 0) {
                return "<";
            }
            if (ParentSelector.this.style == 2 && columnIndex == 1) {
                String result = null;
                try {
                    ConceptProperties cdp;
                    if (element instanceof ReferenceObject && ((result = CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)element), (Attribute)(cdp = (ConceptProperties)ParentSelector.this.displayProps.get(ParentSelector.this.parentRelation.getSelectedRelationship().getParentConcept().getAcronym())).getAttribute(), (String)ParentSelector.this.lang)) == null || result.trim().equals("") || result.trim().equals("...")) && cdp.hasAlternate()) {
                        result = CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)element), (Attribute)cdp.getAlternate(), (String)ParentSelector.this.lang);
                    }
                }
                catch (ReferenceServiceException e) {
                    ComponentsCommons.showExceptionWithStack(e);
                }
                return result;
            }
            if (ParentSelector.this.style == 2 && columnIndex == 2) {
                return ">";
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof ReferenceObject) {
                int coverage = ParentSelector.this.getCoverage((ReferenceObject)element);
                if (coverage >= 0) {
                    if (ParentSelector.this.dimensionSelection != null) {
                        Set objects = CoreCache.getChildren((Relationship)ParentSelector.this.relationship, (ReferenceObject)((ReferenceObject)element));
                        switch (ParentSelector.this.dimensionSelection.whichSide(objects)) {
                            case -1: {
                                return ComponentsCommons.getColor(128, 0, 0);
                            }
                            case 0: {
                                return ComponentsCommons.getColor(0, 0, 0);
                            }
                            case 1: {
                                return ComponentsCommons.getColor(32, 32, 190);
                            }
                        }
                        return ComponentsCommons.getColor(0, 0, 0);
                    }
                } else {
                    return ComponentsCommons.getColor(128, 128, 128);
                }
            }
            return null;
        }
    }
}

