/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;

public class WorkspaceMetadataPanel
extends Composite {
    private WorkspaceModel wksModel = null;
    private AutoUpdateWks wksAutoUpdate = null;
    private String locale;
    private Label lblAcronym;
    private Label lblDescription;
    private Label lblProvider;
    private Label lblName;
    private Label lblVersion;
    private Label lblLocation;

    public WorkspaceMetadataPanel(Composite parent, int style, String locale) {
        super(parent, style);
        this.setBackgroundMode(2);
        this.locale = locale;
        this.setLayout((Layout)new GridLayout(4, false));
        Label lblAcronymLabel = new Label((Composite)this, 0);
        lblAcronymLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAcronymLabel.setAlignment(131072);
        lblAcronymLabel.setText("Acronym");
        this.lblAcronym = new Label((Composite)this, 0);
        this.lblAcronym.setForeground(SWTResourceManager.getColor(10));
        GridData gd_lblAcronymLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblAcronymLabel.widthHint = 160;
        this.lblAcronym.setLayoutData((Object)gd_lblAcronymLabel);
        Label lblVersionLabel = new Label((Composite)this, 0);
        lblVersionLabel.setAlignment(131072);
        GridData gd_lblVersionLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblVersionLabel.widthHint = 70;
        lblVersionLabel.setLayoutData((Object)gd_lblVersionLabel);
        lblVersionLabel.setText("Version");
        this.lblVersion = new Label((Composite)this, 0);
        this.lblVersion.setForeground(SWTResourceManager.getColor(10));
        this.lblVersion.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblNameLabel = new Label((Composite)this, 0);
        lblNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNameLabel.setAlignment(131072);
        lblNameLabel.setText("Name");
        this.lblName = new Label((Composite)this, 0);
        this.lblName.setForeground(SWTResourceManager.getColor(10));
        GridData gd_lblName = new GridData(4, 0x1000000, false, false, 3, 1);
        gd_lblName.widthHint = 37;
        this.lblName.setLayoutData((Object)gd_lblName);
        Label lblDescriptionLabel = new Label((Composite)this, 0);
        GridData gd_lblDescriptionLabel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblDescriptionLabel.widthHint = 64;
        lblDescriptionLabel.setLayoutData((Object)gd_lblDescriptionLabel);
        lblDescriptionLabel.setText("Description");
        this.lblDescription = new Label((Composite)this, 0);
        this.lblDescription.setForeground(SWTResourceManager.getColor(10));
        this.lblDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label lblProviderLabel = new Label((Composite)this, 0);
        lblProviderLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblProviderLabel.setText("Provider");
        this.lblProvider = new Label((Composite)this, 0);
        this.lblProvider.setForeground(SWTResourceManager.getColor(10));
        this.lblProvider.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label lblLocationLabel = new Label((Composite)this, 0);
        lblLocationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLocationLabel.setText("Location");
        this.lblLocation = new Label((Composite)this, 0);
        this.lblLocation.setForeground(SWTResourceManager.getColor(10));
        this.lblLocation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
    }

    public WorkspaceModel getMetadata() {
        return this.wksModel;
    }

    public void setMetadata(Object metadata) {
        if (metadata == null) {
            this.lblAcronym.setText("");
            this.lblDescription.setText("");
            this.lblName.setText("");
            this.lblProvider.setText("");
            this.lblVersion.setText("");
            this.lblLocation.setText("");
        } else {
            if (metadata instanceof WorkspaceModel) {
                this.wksModel = (WorkspaceModel)metadata;
                this.lblAcronym.setText(this.wksModel.hasAcronym() ? this.wksModel.getAcronym() : "");
                this.lblDescription.setText(this.wksModel.hasDescription(this.locale) ? this.wksModel.getDescription(this.locale) : "");
                this.lblName.setText(this.wksModel.hasName(this.locale) ? this.wksModel.getName(this.locale) : "");
                this.lblProvider.setText(this.wksModel.hasProvider(this.locale) ? this.wksModel.getProvider(this.locale) : "");
                this.lblVersion.setText(this.wksModel.hasVersion() ? this.wksModel.getVersion().toString() : "");
                this.lblLocation.setText(this.wksModel.getLocationDir().getAbsolutePath());
            }
            if (metadata instanceof AutoUpdateWks) {
                this.wksAutoUpdate = (AutoUpdateWks)metadata;
                this.lblAcronym.setText(this.wksAutoUpdate.getAcronym());
                this.lblName.setText(this.wksAutoUpdate.getDescription());
                this.lblDescription.setText("Internet: automatic download");
                this.lblVersion.setText(this.wksAutoUpdate.getVersion());
                String url = this.wksAutoUpdate.getUrl();
                this.lblProvider.setText(url.substring(0, url.lastIndexOf(47)));
                this.lblLocation.setText(url.substring(url.lastIndexOf(47)));
            }
        }
    }
}

