/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.menus;

import java.util.Collection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.gui.components.dialogs.ReferenceObjectDialog;
import org.fao.fi.fishstat.gui.components.widgets.WidgetsUtils;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;

public class MenusUtils {
    public static void createRigthClickMenu(final Concept concept, final Control control, final DimensionProperties properties, final String lang) {
        final Menu popupMenu = new Menu(control);
        if ((control.getStyle() & 2) != 0) {
            MenuItem selectAllItem = new MenuItem(popupMenu, 64);
            selectAllItem.setText("Select all");
            selectAllItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (control instanceof List) {
                        ((List)control).selectAll();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem deSelectAllItem = new MenuItem(popupMenu, 0);
            deSelectAllItem.setText("Deselect all");
            deSelectAllItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (control instanceof List) {
                        ((List)control).deselectAll();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem invertSelectiobnItem = new MenuItem(popupMenu, 0);
            invertSelectiobnItem.setText("Invert Selection");
            invertSelectiobnItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WidgetsUtils.invertSelection(control);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            new MenuItem(popupMenu, 2);
        }
        MenuItem chooseAttributeItem = new MenuItem(popupMenu, 64);
        chooseAttributeItem.setText("Choose attribute");
        Menu newMenu = new Menu(popupMenu);
        chooseAttributeItem.setMenu(newMenu);
        Collection attributes = concept.getAttributes();
        for (final Attribute attribute : attributes) {
            if (attribute.getAcronym().equals("ID")) continue;
            MenuItem attributeItem = new MenuItem(newMenu, 0);
            attributeItem.setText(attribute.getName().getValue(lang));
            attributeItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    properties.getSelector(concept.getAcronym()).setAttribute(attribute);
                    properties.storeProperties();
                    properties.getDatasetProperties().commitProperties();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        popupMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                ReferenceObject ro;
                MenuItem[] menuItems = popupMenu.getItems();
                if (menuItems[menuItems.length - 1].getData("ACRONYM") != null && menuItems[menuItems.length - 1].getData("ACRONYM").equals("NOTES_ON")) {
                    menuItems[menuItems.length - 1].dispose();
                }
                if ((ro = (ReferenceObject)control.getData("lastRigthClick")) != null) {
                    Attribute meta_attribute = properties.getSelector(concept.getAcronym()).getAttribute();
                    MenuItem menuItem = new MenuItem(popupMenu, 8);
                    menuItem.setData("ACRONYM", (Object)"NOTES_ON");
                    Object attribute = ro.getAttribute(meta_attribute);
                    final String notesOnLabel = attribute instanceof MultilingualString ? ((MultilingualString)attribute).getValue(lang) : attribute.toString();
                    menuItem.setText("Details on " + notesOnLabel);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            ReferenceObjectDialog dialog = new ReferenceObjectDialog(Display.getDefault().getActiveShell(), ro, notesOnLabel, lang);
                            dialog.open();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
            }
        });
        control.setMenu(popupMenu);
    }
}

