/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.multilingual;

import java.util.Locale;
import org.fao.fi.fishstat.data.common.api.MultilingualString;

public class MultilingualField {
    private MultilingualString mlg;
    private Locale locale;
    private Object owner;

    public MultilingualField(MultilingualString mlg, Locale locale) {
        if (mlg == null) {
            throw new Error("Empty MultilingualString not allowed");
        }
        this.mlg = mlg;
        this.locale = locale;
    }

    public MultilingualField(MultilingualString mlg, String locale) {
        if (mlg == null) {
            throw new Error("Empty MultilingualString not allowed");
        }
        this.mlg = mlg;
        this.locale = new Locale(locale);
    }

    public MultilingualField(MultilingualString mlg, String locale, Object owner) {
        if (mlg == null) {
            throw new Error("Empty MultilingualString not allowed");
        }
        this.mlg = mlg;
        this.locale = new Locale(locale);
        this.owner = owner;
    }

    public String getValue() {
        return this.mlg.getValue(this.locale);
    }

    public String getSafeValue() {
        return this.mlg.getValue(this.locale) != null ? this.mlg.getValue(this.locale) : "";
    }

    public void setValue(String value) {
        this.mlg.setValue(this.locale, value);
    }

    public String getLocaleString() {
        return this.locale.getLanguage();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MultilingualString getMlg() {
        return this.mlg;
    }

    public Object getOwner() {
        return this.owner;
    }
}

