/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.beans.Beans;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.gui.components.providers.content.DatasetsContentProvider;
import org.fao.fi.fishstat.gui.components.providers.labels.DatasetsLabelProvider;
import org.fao.fi.fishstat.gui.components.providers.sorters.DatasetsSorter;

public class DatasetsTreeViewer
extends Composite {
    private String lang;
    private Tree tree;
    private TreeViewer treeViewer;
    private int style;

    public DatasetsTreeViewer(Composite parent, int style, String lang) {
        super(parent, 0);
        this.style = style;
        this.lang = lang;
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.treeViewer = new TreeViewer((Composite)this, this.style);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (!Beans.isDesignTime()) {
            this.treeViewer.setAutoExpandLevel(2);
            this.treeViewer.setContentProvider((IContentProvider)new DatasetsContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new DatasetsLabelProvider(this.lang));
            this.treeViewer.setComparator((ViewerComparator)new DatasetsSorter(this.lang));
            this.treeViewer.setInput((Object)TimeseriesServiceFactory.getService().getDatasets());
        }
    }

    protected void checkSubclass() {
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }
}

