/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;

public class TimeResolutionsComboViewer
extends ComboViewer {
    private String lang;

    public TimeResolutionsComboViewer(Composite composite, int style) {
        super(composite, 0x10000000 | style);
        this.setContentProvider((IContentProvider)new TimeResolutionContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TimeResolutionLabelProvider());
        this.setComparator(new TimeResolutionSorter(this.lang));
    }

    public TimeResolution getSelectedTimeResolution() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (TimeResolution)sel.getFirstElement();
    }

    private class TimeResolutionContentProvider
    implements IStructuredContentProvider {
        private TimeResolutionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return TimeResolution.RESOLUTIONS.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TimeResolutionLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        public String getText(Object element) {
            if (element instanceof TimeResolution) {
                return ((TimeResolution)element).toString();
            }
            return null;
        }
    }

    private class TimeResolutionSorter
    extends ViewerComparator {
        public TimeResolutionSorter(String lang) {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return super.compare(viewer, (Object)e1.toString(), (Object)e2.toString());
        }
    }
}

