/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class FSActions {
    private static HashMap<Integer, String> actionCodes = FSActions._getActionCodes();
    private List<Integer> codes = new LinkedList<Integer>();

    public FSActions() {
    }

    public FSActions(Integer action) {
        this.codes.add(action);
    }

    public FSActions(Integer action1, Integer action2) {
        this.codes.add(action1);
        if (!this.codes.contains(action2)) {
            this.codes.add(action2);
        }
    }

    public FSActions(Integer action1, Integer action2, Integer action3) {
        this.codes.add(action1);
        if (!this.codes.contains(action2)) {
            this.codes.add(action2);
        }
        if (!this.codes.contains(action3)) {
            this.codes.add(action3);
        }
    }

    public void add(Integer v1) {
        if (!this.codes.contains(v1)) {
            this.codes.add(v1);
        }
    }

    public void add(Integer v1, Integer v2) {
        if (!this.codes.contains(v1)) {
            this.codes.add(v1);
        }
        if (!this.codes.contains(v2)) {
            this.codes.add(v2);
        }
    }

    public void add(Integer v1, Integer v2, Integer v3) {
        if (!this.codes.contains(v1)) {
            this.codes.add(v1);
        }
        if (!this.codes.contains(v2)) {
            this.codes.add(v2);
        }
        if (!this.codes.contains(v3)) {
            this.codes.add(v3);
        }
    }

    public void addAll(FSActions actions) {
        this.addAll(actions.toArray());
    }

    public void addAll(Integer[] actions) {
        Integer[] integerArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer action = integerArray[n2];
            this.add(action);
            ++n2;
        }
    }

    public void clear() {
        this.codes.clear();
    }

    public boolean contains(Integer o) {
        return this.codes.contains(o);
    }

    public boolean remove(Integer o) {
        return this.codes.remove(o);
    }

    public int size() {
        return this.codes.size();
    }

    public Integer[] toArray() {
        Collections.sort(this.codes);
        return this.codes.toArray(new Integer[0]);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        for (Integer code : this.codes) {
            res.append(actionCodes.get(code));
            res.append(", ");
        }
        return res.substring(0, res.length() - 2);
    }

    private static HashMap<Integer, String> _getActionCodes() {
        HashMap<Integer, String> res = null;
        try {
            Class<?> fs_class = Class.forName("org.fao.fi.fishstat.core.IFSActions");
            Field[] fields = fs_class.getDeclaredFields();
            res = new HashMap<Integer, String>(fields.length);
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                res.put(field.getInt(null), field.getName());
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }
}

