/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.concept;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.concept.ConceptAttributeModel;
import org.fao.fi.fishstat.core.model.concept.ConceptModel;
import org.fao.fi.fishstat.core.model.concept.ConceptModelImpl;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;

public class ConceptAttributeModelImpl
implements ConceptAttributeModel,
PropertyChangeListener {
    private ConceptModelImpl concept;
    private Attribute originalInstance;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected String acronym;
    protected Integer sortorder;
    protected MultilingualStringWrapper name;
    protected MultilingualStringWrapper description;
    protected short scale;
    protected short size;
    protected AttributeType type;
    protected boolean idAttribute;
    protected boolean codeAttribute;
    protected boolean nameAttribute;

    protected ConceptAttributeModelImpl(ConceptModelImpl concept) {
        this.concept = concept;
        this.name = new MultilingualStringWrapper();
        this.description = new MultilingualStringWrapper();
        this.propertyChangeSupport.addPropertyChangeListener(concept);
        this.setDefaults();
    }

    protected ConceptAttributeModelImpl(ConceptModelImpl concept, Attribute attribute) {
        this.concept = concept;
        this.originalInstance = attribute;
        this.syncInstance(attribute);
        this.propertyChangeSupport.addPropertyChangeListener(concept);
    }

    private void syncInstance(Attribute attribute) {
        this.acronym = attribute.getAcronym();
        this.idAttribute = this.acronym.equalsIgnoreCase("ID");
        this.name = new MultilingualStringWrapper("name", attribute.getName(), this);
        this.description = new MultilingualStringWrapper("description", attribute.getDescription(), this);
        this.scale = attribute.getScale();
        this.size = attribute.getSize();
        this.type = attribute.getType();
        this.codeAttribute = attribute.isCodeAttribute();
        this.nameAttribute = attribute.isNameAttribute();
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(acronym) + ".acronym", this.acronym, this.acronym);
    }

    @Override
    public Integer getSortorder() {
        return this.sortorder;
    }

    @Override
    public void setSortorder(Integer sortorder) {
        this.sortorder = sortorder;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(this.acronym) + ".sortorder", this.sortorder, this.sortorder);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(this.acronym) + ".name", this.name, this.name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(this.acronym) + ".description", this.description, this.description);
    }

    @Override
    public short getScale() {
        return this.scale;
    }

    @Override
    public void setScale(short scale) {
        this.scale = scale;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(this.acronym) + ".scale", this.scale, this.scale);
    }

    @Override
    public short getSize() {
        return this.size;
    }

    @Override
    public void setSize(short size) {
        this.size = size;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(this.acronym) + ".size", this.size, this.size);
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public void setType(AttributeType type) {
        this.type = type;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(this.acronym) + ".type", this.type, this.type);
    }

    @Override
    public void setInstance(Attribute instance) {
        this.originalInstance = instance;
    }

    @Override
    public boolean isCodeAttribute() {
        return this.codeAttribute;
    }

    @Override
    public void setCodeAttribute(boolean codeAttribute) {
        this.codeAttribute = codeAttribute;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(this.acronym) + ".codeAttribute", this.codeAttribute, this.codeAttribute);
    }

    @Override
    public boolean isIdAttribute() {
        return this.idAttribute;
    }

    @Override
    public boolean isNameAttribute() {
        return this.nameAttribute;
    }

    @Override
    public void setNameAttribute(boolean nameAttribute) {
        this.nameAttribute = nameAttribute;
        this.propertyChangeSupport.firePropertyChange(String.valueOf(this.acronym) + ".nameAttribute", this.nameAttribute, this.nameAttribute);
    }

    @Override
    public Object getInstance() {
        return this.originalInstance;
    }

    @Override
    public boolean isNative() {
        return this.originalInstance != null;
    }

    @Override
    public ConceptModel getConcept() {
        return this.concept;
    }

    @Override
    public boolean isSynchronised() {
        if (this.originalInstance == null) {
            return false;
        }
        if (!this.originalInstance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!this.originalInstance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.originalInstance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        if (this.originalInstance.getScale() != this.scale) {
            return false;
        }
        if (this.originalInstance.getSize() != this.size) {
            return false;
        }
        if (!this.originalInstance.getType().equals((Object)this.type)) {
            return false;
        }
        if (this.originalInstance.isCodeAttribute() != this.codeAttribute) {
            return false;
        }
        return this.originalInstance.isNameAttribute() == this.nameAttribute;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.propertyChangeSupport.firePropertyChange(event);
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) {
    }

    private void setDefaults() {
        this.acronym = this.getNewAttributeAcronym();
        this.type = AttributeType.MULTILINGUAL_STRING;
        this.size = (short)80;
        this.scale = 0;
        this.nameAttribute = true;
        this.codeAttribute = false;
        this.name = new MultilingualStringWrapper();
        this.description = new MultilingualStringWrapper();
    }

    private String getNewAttributeAcronym() {
        String base = "NEW_ATTRIBUTE";
        int i = 0;
        while (i <= 100) {
            String candidate_acronym = String.valueOf(base) + "_" + i;
            if (!this.concept.hasAttribute(candidate_acronym)) {
                return candidate_acronym;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isOwnerUsingAcronym(String acronym) {
        return this.concept.hasAttribute(acronym);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

