/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.concept.relationship;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.concept.relationship.ConceptRelationshipModel;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class ConceptRelationshipModelImpl
implements ConceptRelationshipModel,
PropertyChangeListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Relationship instance;
    private String acronym;
    private Integer sortorder;
    private MultilingualStringWrapper name;
    private MultilingualStringWrapper description;
    private Concept child;
    private Concept parent;
    private boolean isSystemConceptRelationship = false;

    public ConceptRelationshipModelImpl(Relationship relationship, boolean clone) {
        if (!clone) {
            this.instance = relationship;
        }
        this.syncInstance(relationship);
    }

    public ConceptRelationshipModelImpl() {
        this.acronym = ConceptRelationshipModelImpl.getNewRelationshipAcronym();
    }

    private void syncInstance(Relationship relationship) {
        this.acronym = relationship.getAcronym();
        this.name = new MultilingualStringWrapper("name", new MultilingualString(relationship.getName()), this);
        this.description = new MultilingualStringWrapper("description", new MultilingualString(relationship.getDescription()), this);
        this.parent = relationship.getParentConcept();
        this.child = relationship.getChildConcept();
        this.isSystemConceptRelationship = CoreCommons.getWorkspaceSystemEntities().isSystemRelationship(relationship);
        this.sortorder = relationship.getSortorder();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public Relationship getInstance() {
        return this.instance;
    }

    @Override
    public void setInstance(Relationship instance) {
        this.instance = instance;
    }

    @Override
    public boolean isNative() {
        return this.instance != null;
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", this.acronym, this.acronym);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public Concept getChild() {
        return this.child;
    }

    @Override
    public void setChild(Concept child) {
        this.child = child;
        this.propertyChangeSupport.firePropertyChange("child", this.child, this.child);
    }

    @Override
    public Concept getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Concept parent) {
        this.parent = parent;
        this.propertyChangeSupport.firePropertyChange("parent", this.parent, this.parent);
    }

    @Override
    public boolean isSystemConceptRelationship() {
        return this.isSystemConceptRelationship;
    }

    @Override
    public boolean isSynchronised() {
        if (this.instance == null) {
            return false;
        }
        if (!this.instance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!this.instance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.instance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        if (!this.instance.getParentConcept().equals(this.parent)) {
            return false;
        }
        if (!this.instance.getChildConcept().equals(this.child)) {
            return false;
        }
        return this.sortorder == null || this.instance.getSortorder().equals(this.sortorder);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public static String getNewRelationshipAcronym() {
        String base = "NEW_RELATIONSHIP";
        int i = 0;
        while (i <= 100) {
            if (ReferenceServiceFactory.getService().getRelationship(String.valueOf(base) + "_" + i) == null) {
                return String.valueOf(base) + "_" + i;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) {
    }

    @Override
    public void setSortorder(Integer sortOrder) {
        this.sortorder = sortOrder;
        this.propertyChangeSupport.firePropertyChange("sortorder", this.sortorder, this.sortorder);
    }

    @Override
    public Integer getSortorder() {
        return this.sortorder;
    }
}

