/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.concept.selection;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;

public class ConceptSelection
extends Observable
implements Serializable {
    public static final int INCLUDEDS_SIDE = 1;
    public static final int EXCLUDEDS_SIDE = 2;
    public static final int ALL_EXCLUDED = -1;
    public static final int BOTH_PARTS = 0;
    public static final int ALL_INCLUDED = 1;
    private static final long serialVersionUID = 1L;
    private Concept concept;
    private Set<ReferenceObject> includes;
    private Set<ReferenceObject> excludes;
    private Set<ReferenceObject> all;

    public ConceptSelection(Concept concept) throws ReferenceServiceException {
        this.concept = concept;
        this.initialize(null);
    }

    public ConceptSelection(Concept concept, Set<ReferenceObject> subset) throws ReferenceServiceException {
        this.concept = concept;
        this.initialize(subset);
    }

    public void initialize(Set<ReferenceObject> source) {
        this.all = source == null ? (this.concept != null ? new HashSet<ReferenceObject>(this.concept.getObjects()) : new HashSet<ReferenceObject>()) : source;
        this.excludes = new HashSet<ReferenceObject>(this.all);
        this.includes = new HashSet<ReferenceObject>(this.all.size());
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public Concept getConcept() {
        return this.concept;
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
        this.initialize(null);
    }

    public void addIncludes(ReferenceObject[] set) {
        HashSet<ReferenceObject> filtered = new HashSet<ReferenceObject>(set.length);
        ReferenceObject[] referenceObjectArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceObject referenceObject = referenceObjectArray[n2];
            if (this.all.contains(referenceObject)) {
                filtered.add(referenceObject);
            }
            ++n2;
        }
        this.includes.addAll(filtered);
        this.excludes.removeAll(filtered);
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public void addIncludes(Set<ReferenceObject> set) {
        HashSet<ReferenceObject> filtered = new HashSet<ReferenceObject>(set.size());
        for (ReferenceObject referenceObject : set) {
            if (!this.all.contains(referenceObject)) continue;
            filtered.add(referenceObject);
        }
        this.includes.addAll(filtered);
        this.excludes.removeAll(filtered);
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public void remIncludes(ReferenceObject[] set) {
        HashSet<ReferenceObject> filtered = new HashSet<ReferenceObject>(set.length);
        ReferenceObject[] referenceObjectArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceObject referenceObject = referenceObjectArray[n2];
            if (this.all.contains(referenceObject)) {
                filtered.add(referenceObject);
            }
            ++n2;
        }
        this.excludes.addAll(filtered);
        this.includes.removeAll(filtered);
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public void remIncludes(Set<ReferenceObject> set) {
        HashSet<ReferenceObject> filtered = new HashSet<ReferenceObject>(set.size());
        for (ReferenceObject referenceObject : set) {
            if (!this.all.contains(referenceObject)) continue;
            filtered.add(referenceObject);
        }
        this.excludes.addAll(filtered);
        this.includes.removeAll(filtered);
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public void addIncluded(ReferenceObject ro) {
        this.includes.add(ro);
        this.excludes.remove(ro);
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public void remIncluded(ReferenceObject ro) {
        this.excludes.add(ro);
        this.includes.remove(ro);
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public void includeAll() {
        this.includes.addAll(this.all);
        this.excludes = new HashSet<ReferenceObject>(this.all.size());
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public void excludeAll() {
        this.excludes.addAll(this.all);
        this.includes = new HashSet<ReferenceObject>(this.all.size());
        this.setChanged();
        this.notifyObservers(new String[]{"include", "exclude"});
    }

    public Set<ReferenceObject> getAll() {
        return this.all;
    }

    public Set<ReferenceObject> getIncludes() {
        return this.includes;
    }

    public List<ReferenceObject> getIncludesList() {
        return new LinkedList<ReferenceObject>(this.includes);
    }

    public Set<ReferenceObject> getExcludes() {
        return this.excludes;
    }

    public List<ReferenceObject> getExcludesList() {
        return new LinkedList<ReferenceObject>(this.excludes);
    }

    public int getAllSize() {
        return this.all.size();
    }

    public int getIncludesSize() {
        return this.includes.size();
    }

    public int getExcludesSize() {
        return this.excludes.size();
    }

    public boolean isNothingIncluded() {
        return this.includes.size() == 0;
    }

    public boolean isNothingExcluded() {
        return this.excludes.size() == 0;
    }

    public ConceptSelection clone() {
        try {
            HashSet<ReferenceObject> newAll = new HashSet<ReferenceObject>(this.all);
            ConceptSelection result = new ConceptSelection(this.concept, newAll);
            result.addIncludes(this.includes);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int whichSide(ReferenceObject ro) {
        if (this.isNothingIncluded() || this.excludes.contains(ro)) {
            return -1;
        }
        if (this.isNothingExcluded() || this.includes.contains(ro)) {
            return 1;
        }
        return 0;
    }

    public int whichSide(Set<ReferenceObject> ros) {
        if (this.isNothingIncluded() || this.excludes.containsAll(CoreUtils.filetrSet(this.all, ros))) {
            return -1;
        }
        if (this.isNothingExcluded() || this.includes.containsAll(CoreUtils.filetrSet(this.all, ros))) {
            return 1;
        }
        return 0;
    }
}

