/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.session;

import java.util.Date;
import java.util.UUID;
import org.fao.fi.fishstat.core.ActionDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public class SessionDescriptor {
    private int id;
    private UUID uuid;
    protected Timeseries timeseries;
    protected int size;
    protected ActionDescriptor filter;
    protected ActionDescriptor aggregation;
    protected ActionDescriptor topCriteria;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public SessionDescriptor() {
        this.uuid = UUID.randomUUID();
    }

    public SessionDescriptor(String uuid) {
        this.uuid = UUID.fromString(uuid);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getDate() {
        return new Date(this.uuid.timestamp()).toString();
    }

    public Dataset getDataset() {
        return this.timeseries.getDataset();
    }

    public Timeseries getTimeseries() {
        return this.timeseries;
    }

    public void setTimeseries(Timeseries timeseries) {
        this.timeseries = timeseries;
    }

    public ActionDescriptor getFilter() {
        return this.filter;
    }

    public void setFilter(ActionDescriptor filter) {
        this.filter = filter;
    }

    public ActionDescriptor getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(ActionDescriptor aggregation) {
        this.aggregation = aggregation;
    }

    public ActionDescriptor getTopCriteria() {
        return this.topCriteria;
    }

    public void setTopCriteria(ActionDescriptor topCriteria) {
        this.topCriteria = topCriteria;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SessionDescriptor) {
            return ((SessionDescriptor)obj).getUuid().equals(this.uuid);
        }
        return false;
    }
}

