/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.xmlbinds.workspaces;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.concept.ConceptAttributeModel;
import org.fao.fi.fishstat.core.model.concept.ConceptModel;
import org.fao.fi.fishstat.core.model.concept.ConceptModelImpl;
import org.fao.fi.fishstat.core.model.concept.relationship.ConceptRelationshipModel;
import org.fao.fi.fishstat.core.model.concept.relationship.ConceptRelationshipModelImpl;
import org.fao.fi.fishstat.core.model.dataset.DatasetModel;
import org.fao.fi.fishstat.core.model.dataset.DatasetModelImpl;
import org.fao.fi.fishstat.core.model.dataset.DimensionModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesAttributeModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModelImpl;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Attribute;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Concept;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Relationship;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.customgroups.Customgroup;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Dataset;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Dimension;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Timeseries;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;

public class WorkspaceAdapters {
    public static ConceptModel getConcept(Concept xmlConcept) throws Exception {
        ConceptModelImpl res = new ConceptModelImpl();
        res.setAcronym(xmlConcept.getAcronym());
        res.setName(WorkspaceAdapters.getMultilingualStringWrapper(xmlConcept.getName()));
        res.setDescription(WorkspaceAdapters.getMultilingualStringWrapper(xmlConcept.getDescription()));
        for (Attribute xmlAttribute : xmlConcept.getAttributes().getAttribute()) {
            res.addAttribute(WorkspaceAdapters.getAttributeModel(res, xmlAttribute));
        }
        return res;
    }

    public static ConceptRelationshipModel getConceptRelationship(Relationship xmlRelationship) throws Exception {
        ConceptRelationshipModelImpl res = new ConceptRelationshipModelImpl();
        res.setAcronym(xmlRelationship.getAcronym());
        res.setDescription(WorkspaceAdapters.getMultilingualStringWrapper(xmlRelationship.getDescription()));
        res.setName(WorkspaceAdapters.getMultilingualStringWrapper(xmlRelationship.getName()));
        res.setSortorder(xmlRelationship.getSortOrder());
        res.setChild(ReferenceServiceFactory.getService().getConcept(xmlRelationship.getChild()));
        res.setParent(ReferenceServiceFactory.getService().getConcept(xmlRelationship.getParent()));
        return res;
    }

    public static ReferenceObject getCustomGroup(Customgroup xmlcustomgroup) throws Exception {
        org.fao.fi.fishstat.data.reference.api.Concept cg_concept = ReferenceServiceFactory.getService().getConcept("CUSTOM_GROUP");
        ReferenceObject res = cg_concept.createObject();
        res.setAttribute("NAME", (Object)WorkspaceAdapters.getMultilingualStringWrapper(xmlcustomgroup.getName()).getInstance());
        res.setAttribute("DESCRIPTION", (Object)WorkspaceAdapters.getMultilingualStringWrapper(xmlcustomgroup.getDescription()).getInstance());
        res.setAttribute("MEMBERS_CONCEPT", (Object)xmlcustomgroup.getConcept());
        return res;
    }

    private static ConceptAttributeModel getAttributeModel(ConceptModel conceptModel, Attribute xmlAttribute) throws Exception {
        ConceptAttributeModel res = conceptModel.createNewAttribute();
        res.setAcronym(xmlAttribute.getAcronym());
        res.setCodeAttribute(xmlAttribute.isIscode());
        res.setDescription(WorkspaceAdapters.getMultilingualStringWrapper(xmlAttribute.getDescription()));
        res.setName(WorkspaceAdapters.getMultilingualStringWrapper(xmlAttribute.getName()));
        res.setNameAttribute(xmlAttribute.isIsname());
        res.setScale(xmlAttribute.getScale().shortValue());
        res.setSize(xmlAttribute.getSize().shortValue());
        res.setType(AttributeType.valueOf((String)xmlAttribute.getType()));
        return res;
    }

    private static MultilingualStringWrapper getMultilingualStringWrapper(List<?> lang_strings) throws Exception {
        MultilingualStringWrapper res = new MultilingualStringWrapper();
        for (Object lang_string : lang_strings) {
            Method getLangMethod = lang_string.getClass().getMethod("getLang", new Class[0]);
            Method getValueMethod = lang_string.getClass().getMethod("getValue", new Class[0]);
            res.setValue((String)getLangMethod.invoke(lang_string, new Object[0]), (String)getValueMethod.invoke(lang_string, new Object[0]));
        }
        return res;
    }

    public static DatasetModel getDataset(Dataset xml_dataset, ILog logger) throws Exception {
        DatasetModelImpl dmRes = new DatasetModelImpl();
        dmRes.setAcronym(xml_dataset.getAcronym());
        dmRes.setUrl(xml_dataset.getUrl());
        dmRes.setDatasource(new DataSource(xml_dataset.getDatasource()));
        dmRes.setName(WorkspaceAdapters.getMultilingualStringWrapper(xml_dataset.getName()));
        dmRes.setDescription(WorkspaceAdapters.getMultilingualStringWrapper(xml_dataset.getDescription()));
        dmRes.setCitation(xml_dataset.getCitation());
        VersionId version = new VersionId("1.0.0");
        version.setAuthor("Statistical Clerk");
        version.setDateDate(new Date());
        dmRes.setVersion(version);
        logger.log((IStatus)new Status(1, "datasets.import.wizard", "found " + xml_dataset.getDimension().size() + " dimensions"));
        for (Dimension xmlDimension : xml_dataset.getDimension()) {
            dmRes.addDimension(WorkspaceAdapters.getDimensionModel(dmRes, xmlDimension, logger));
        }
        return dmRes;
    }

    public static TimeseriesModel getTimeseries(String dataset_acronym, Timeseries xml_timeseries) throws Exception {
        TimeseriesModelImpl tsRes = new TimeseriesModelImpl(dataset_acronym);
        tsRes.setAcronym(xml_timeseries.getAcronym());
        tsRes.setDatasource(new DataSource(xml_timeseries.getDatasource()));
        tsRes.setFirstObservationPeriod(new ObservationPeriod(xml_timeseries.getFirstperiod()));
        tsRes.setLastObservationPeriod(new ObservationPeriod(xml_timeseries.getLastperiod()));
        tsRes.setTimeResolution(TimeResolution.valueOf((String)xml_timeseries.getTimeresolution()));
        tsRes.setName(WorkspaceAdapters.getMultilingualStringWrapper(xml_timeseries.getName()));
        tsRes.setDescription(WorkspaceAdapters.getMultilingualStringWrapper(xml_timeseries.getDescription()));
        for (org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Attribute attribute : xml_timeseries.getAttributes().getAttribute()) {
            TimeseriesAttributeModel attributeModel = tsRes.createNewAttribute();
            attributeModel.setAcronym(attribute.getAcronym());
            attributeModel.setValue(attribute.getValue());
            attributeModel.setName(WorkspaceAdapters.getMultilingualStringWrapper(attribute.getName()));
            attributeModel.setDescription(WorkspaceAdapters.getMultilingualStringWrapper(attribute.getDescription()));
            tsRes.addAttribute(attributeModel);
        }
        return tsRes;
    }

    private static DimensionModel getDimensionModel(DatasetModel datasetModel, Dimension xmlDimension, ILog logger) throws Exception {
        logger.log((IStatus)new Status(1, "datasets.import.wizard", "adding dimension " + xmlDimension.getAcronym()));
        DimensionModel dimRes = datasetModel.createNewDimension();
        dimRes.setAcronym(xmlDimension.getAcronym());
        org.fao.fi.fishstat.data.reference.api.Concept concept = ReferenceServiceFactory.getService().getConcept(xmlDimension.getConcept());
        if (concept == null) {
            logger.log((IStatus)new Status(4, "datasets.import.wizard", "canot get concept for " + xmlDimension.getConcept()));
            return null;
        }
        dimRes.setConcept(concept);
        if (xmlDimension.getAttribute() == null) {
            logger.log((IStatus)new Status(4, "datasets.import.wizard", "canot get attribute for " + xmlDimension.getAttribute()));
        }
        dimRes.setAttribute(concept.getAttribute(xmlDimension.getAttribute()));
        if (xmlDimension.getName() == null) {
            logger.log((IStatus)new Status(4, "datasets.import.wizard", "canot get name for " + xmlDimension.getName()));
        }
        dimRes.setName(WorkspaceAdapters.getMultilingualStringWrapper(xmlDimension.getName()));
        if (xmlDimension.getDescription() == null) {
            logger.log((IStatus)new Status(4, "datasets.import.wizard", "canot get description for " + xmlDimension.getDescription()));
        }
        dimRes.setDescription(WorkspaceAdapters.getMultilingualStringWrapper(xmlDimension.getDescription()));
        if (xmlDimension.isIsmeasure()) {
            dimRes.setMeasure(xmlDimension.isIsmeasure());
        }
        return dimRes;
    }
}

