/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.fao.fi.fishstat.gui.ApplicationPreferences;
import org.fao.fi.fishstat.gui.PropertyAdvisor;
import org.fao.fi.fishstat.gui.StatusBarController;
import org.fao.fi.fishstat.gui.components.dialogs.NotYetImplementedDialog;
import org.fao.fi.fishstat.gui.preferences.ApplicationPreferencesInitializer;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final ResourceBundle pluginBundle = ResourceBundle.getBundle("plugin");
    private static String LOCALE2 = Platform.getNL().substring(0, 2);
    public static final String YES_ID = Activator.getLocalString("label.yes.first.upper");
    public static final String NO_ID = Activator.getLocalString("label.no.first.upper");
    public static final String CANCEL_ID = Activator.getLocalString("label.cancel.first.upper");
    public static final String OK_ID = Activator.getLocalString("label.ok.first.upper");
    public static final String PLUGIN_ID = "org.fao.fi.fishstat.gui";
    private static Activator plugin;
    private StatusBarController statusBarController = null;
    private PropertyAdvisor propertyAdvisor;
    private IPreferenceStore store = null;

    public Activator() {
        if (!(LOCALE2.equals("en") || LOCALE2.equals("fr") || LOCALE2.equals("es"))) {
            LOCALE2 = "en";
            System.out.println("org.fao.fi.fishstat.gui.Activator locale is : " + Platform.getNL() + " setting to " + LOCALE2);
        } else {
            System.out.println("org.fao.fi.fishstat.gui.Activator locale : " + Platform.getNL());
        }
    }

    public static String getLanguage() {
        return LOCALE2;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.store = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "fishstatj.gui");
        new ApplicationPreferencesInitializer().initializeDefaultPreferences();
        ApplicationPreferences.assignPreferences();
        this.statusBarController = new StatusBarController();
        this.propertyAdvisor = new PropertyAdvisor();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.propertyAdvisor);
    }

    public void startup() throws CoreException {
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void changeLocale(String locale) {
        System.out.println("changeLocale(" + locale + ") " + Platform.getInstallLocation().getURL().getFile());
        String path = String.valueOf(Platform.getInstallLocation().getURL().getFile()) + "configuration" + System.getProperty("file.separator") + "config.ini";
        Properties props = new Properties();
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(path);
            props.load(fis);
            fis.close();
            props.setProperty("osgi.nl", locale);
            fos = new FileOutputStream(path);
            props.store(fos, "Edited by FishstatJ");
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            fis.close();
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void notYetImplementedMessage() {
        NotYetImplementedDialog nyi = new NotYetImplementedDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        nyi.open();
    }

    public StatusBarController getStatusBarController() {
        return this.statusBarController;
    }

    public void setApplicationTitlePostfix(String postfix) {
        String prefix = postfix == null || postfix.equals("") ? "FishstatJ" : "FishstatJ - ";
        this.getWorkbench().getActiveWorkbenchWindow().getShell().setText(String.valueOf(prefix) + postfix);
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)fileName);
    }

    public static Image getImage(String fileName) {
        ImageDescriptor descriptor = Activator.getImageDescriptor(fileName);
        return descriptor != null ? descriptor.createImage() : null;
    }

    public static Color getColor(int r, int g, int b) {
        return new Color((Device)PlatformUI.getWorkbench().getDisplay(), r, g, b);
    }

    public static ResourceBundle getPluginBundle() {
        return pluginBundle;
    }

    public static String getLocalString(String key) {
        try {
            return pluginBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "<@missing label@>";
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.store;
    }
}

