/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import java.io.File;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.widgets.combos.DatasetAttachmentsComboViewer;

public class DatasetAttachmentsComposite
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Browser browser;
    private String attachmentsPath;
    private DatasetAttachmentsComboViewer datasetAttachmentsComboViewer;
    private String emptyBrowser = "<html><body><p><span lang=EN-GB style='font-size:8.0pt;font-family:\"Arial\",\"sans-serif\";color:#17365D'>Choosing...</span></p></body></html>";
    private String noAttachmentsAvailable = "<html><body><p><span lang=EN-GB style='font-size:9.0pt;font-family:\"Arial\",\"sans-serif\";color:#17365D'>" + Activator.getLocalString("message.no.attachments.available") + "</span></p></body></html>";
    private CLabel lblDescription;

    public DatasetAttachmentsComposite(Composite parent, int style) {
        super(parent, style);
        this.attachmentsPath = CoreRegistry.getAttachmentsPath().getAbsolutePath();
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(SWTResourceManager.getColor(19));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        this.setLayout((Layout)gridLayout);
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        Label lblNewLabel = new Label((Composite)this, 0);
        GridData gd_lblNewLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel.widthHint = 105;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        this.toolkit.adapt((Control)lblNewLabel, true, true);
        lblNewLabel.setText(Activator.getLocalString("label.attachments"));
        this.datasetAttachmentsComboViewer = new DatasetAttachmentsComboViewer((Composite)this, 0, Activator.getLanguage());
        this.datasetAttachmentsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DatasetAttachmentsComposite.this.browser.setText(DatasetAttachmentsComposite.this.emptyBrowser);
                DatasetAttachmentsComposite.this.browser.back();
                Attachment selection = DatasetAttachmentsComposite.this.datasetAttachmentsComboViewer.getSelectedAttachment();
                if (selection != null && selection.getFileName() != null) {
                    String url = String.valueOf(DatasetAttachmentsComposite.this.attachmentsPath) + File.separator + selection.getFileName().getValue(Activator.getLanguage());
                    DatasetAttachmentsComposite.this.browser.setUrl(url);
                    DatasetAttachmentsComposite.this.lblDescription.setText(selection.getDescription().getValue(Activator.getLanguage()));
                }
            }
        });
        this.datasetAttachmentsComboViewer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.adapt((Composite)this.datasetAttachmentsComboViewer);
        this.toolkit.paintBordersFor((Composite)this.datasetAttachmentsComboViewer);
        this.browser = new Browser((Composite)this, 0);
        this.browser.setJavascriptEnabled(false);
        this.browser.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        this.toolkit.adapt((Composite)this.browser);
        this.toolkit.paintBordersFor((Composite)this.browser);
        this.lblDescription = new CLabel((Composite)this, 0);
        this.lblDescription.setBackground(SWTResourceManager.getColor(240, 248, 255));
        this.lblDescription.setForeground(SWTResourceManager.getColor(10));
        this.lblDescription.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.toolkit.adapt((Composite)this.lblDescription);
        this.toolkit.paintBordersFor((Composite)this.lblDescription);
        this.lblDescription.setText("");
    }

    public final void setInput(Object input) {
        this.datasetAttachmentsComboViewer.setInput(input);
        if (this.datasetAttachmentsComboViewer.getItemCount() == 0) {
            this.browser.setText(this.noAttachmentsAvailable);
            this.lblDescription.setText("");
        } else {
            Attachment firstAttachment = (Attachment)this.datasetAttachmentsComboViewer.getComboViewer().getElementAt(0);
            this.datasetAttachmentsComboViewer.setSelection(firstAttachment);
            this.lblDescription.setText(firstAttachment.getDescription().getValue(Activator.getLanguage()));
        }
    }

    public DatasetAttachmentsComboViewer getDatasetAttachmentsComboViewer() {
        return this.datasetAttachmentsComboViewer;
    }
}

