/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.widgets.DatasetsTreeViewer;
import org.fao.fi.fishstat.gui.dataset.management.DatasetManagementComposite;

public class DatasetManagementLeftComposite
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private DatasetManagementComposite mainComposite;
    private DatasetsTreeViewer datasetsTreeViewer;

    public DatasetManagementLeftComposite(Composite parent, int style) {
        super(parent, style);
        if (parent instanceof DatasetManagementComposite) {
            this.mainComposite = (DatasetManagementComposite)parent;
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DatasetManagementLeftComposite.this.toolkit.dispose();
            }
        });
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new FillLayout(256));
        Section sctDatasets = this.toolkit.createSection((Composite)this, 256);
        sctDatasets.setText(Activator.getLocalString("label.dataset.first.upper"));
        Composite composite = this.toolkit.createComposite((Composite)sctDatasets, 0);
        composite.setBackgroundMode(2);
        sctDatasets.setClient((Control)composite);
        composite.setLayout((Layout)new FillLayout(256));
        this.datasetsTreeViewer = new DatasetsTreeViewer(composite, 0x40000000, Activator.getLanguage());
        Tree tree = this.datasetsTreeViewer.getTreeViewer().getTree();
        tree.setFont(SWTResourceManager.getFont("Arial", 8, 0));
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 278;
        tree.setLayoutData((Object)gd_tree);
        this.datasetsTreeViewer.getTreeViewer().setAutoExpandLevel(2);
        this.datasetsTreeViewer.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DatasetManagementLeftComposite.this.mainComposite.getHostTitleAreaDialog().okPressed();
            }
        });
        this.datasetsTreeViewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DatasetManagementLeftComposite.this.selectTreeItem(((TreeSelection)event.getSelection()).getFirstElement());
            }
        });
        sctDatasets.setExpanded(true);
    }

    private void selectTreeItem(Object selection) {
        if (selection instanceof Dataset) {
            this.mainComposite.getCmpRight().getDatasetMetadataComposite().renderDataset((Dataset)selection);
            this.mainComposite.getCmpRight().getDimensionsTabbedDisplayer().renderDataset((Dataset)selection);
            this.mainComposite.getCmpRight().getTimeseriesMetadataComposite().renderTimeseries(null);
            this.mainComposite.getCmpRight().getDatasetAttachmentsComposite().setInput((Dataset)selection);
        } else if (selection instanceof Timeseries) {
            Dataset dataset = ((Timeseries)selection).getDataset();
            this.mainComposite.getCmpRight().getDatasetMetadataComposite().renderDataset(dataset);
            this.mainComposite.getCmpRight().getDimensionsTabbedDisplayer().renderDataset(dataset);
            this.mainComposite.getCmpRight().getTimeseriesMetadataComposite().renderTimeseries((Timeseries)selection);
            this.mainComposite.getCmpRight().getDatasetAttachmentsComposite().setInput(dataset);
        }
    }

    public DatasetsTreeViewer getDatasetsTreeViewer() {
        return this.datasetsTreeViewer;
    }
}

