/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.GuiCommons;
import org.fao.fi.fishstat.gui.dataset.management.DatasetManagementRigthComposite;

public class DatasetMetadataDialog
extends TitleAreaDialog {
    private Timeseries timeseries = null;

    public DatasetMetadataDialog(Shell parentShell, Timeseries timeseries) {
        super(parentShell);
        this.timeseries = timeseries;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/sugar-cubes-icon.png"));
        this.setMessage(String.valueOf(CoreUtils.getCurrentLang((MultilingualString)this.timeseries.getDataset().getName(), (String)Activator.getLanguage())) + " - " + CoreUtils.getCurrentLang((MultilingualString)this.timeseries.getName(), (String)Activator.getLanguage()));
        this.setTitle(Activator.getLocalString("label.metadata.first.upper"));
        Composite area = (Composite)super.createDialogArea(parent);
        DatasetManagementRigthComposite container = new DatasetManagementRigthComposite(area, 0);
        container.getDatasetMetadataComposite().renderDataset(this.timeseries.getDataset());
        container.getDimensionsTabbedDisplayer().renderDataset(this.timeseries.getDataset());
        container.getDatasetAttachmentsComposite().setInput(this.timeseries.getDataset());
        container.getTimeseriesMetadataComposite().renderTimeseries(this.timeseries);
        container.setLayoutData(new GridData(1808));
        container.setLayout((Layout)new GridLayout(1, false));
        return area;
    }

    protected void configureShell(Shell newShell) {
        newShell.setBackgroundMode(2);
        newShell.setBackground(SWTResourceManager.getColor(1));
        super.configureShell(newShell);
        newShell.setImage(Activator.getImage("icons/actions/sugar-cubes-24.png"));
        newShell.setText(Activator.getLocalString("label.metadata.first.upper"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(745 < GuiCommons.clientArea.width ? 745 : GuiCommons.clientArea.width, 750 < GuiCommons.clientArea.height ? 750 : GuiCommons.clientArea.height);
    }
}

