/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.IGraphicsElements;

public class DatasetMetadataUpperComposite
extends Composite
implements IGraphicsElements {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Label lblName;
    private Label lblAcronymLabel;
    private Label lblAcronym;
    private Label lblDescriptionLabel;
    private Label lblDescription;
    private Label lblUrlLabel;
    private Label lblUrl;
    private Label lblDateLabel;
    private Label lblDate;
    private Label lblSourceLabel;
    private Label lblSource;

    public DatasetMetadataUpperComposite(Composite parent, int style) {
        super(parent, style);
        this.setFont(TAHOMA_NORMAL);
        this.setBackgroundMode(2);
        this.setBackground(SWTResourceManager.getColor(1));
        this.initComponents();
    }

    private void initComponents() {
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new FormLayout());
        Label lblNameLabel = this.toolkit.createLabel((Composite)this, Activator.getLocalString("label.name.first.upper"), 256);
        lblNameLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        FormData fd_lblNameLabel = new FormData();
        fd_lblNameLabel.bottom = new FormAttachment(0, 17);
        fd_lblNameLabel.right = new FormAttachment(0, 119);
        fd_lblNameLabel.top = new FormAttachment(0, 4);
        fd_lblNameLabel.left = new FormAttachment(0, 4);
        lblNameLabel.setLayoutData((Object)fd_lblNameLabel);
        lblNameLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        lblNameLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblName = this.toolkit.createLabel((Composite)this, "", 256);
        this.lblName.setBackground(SWTResourceManager.getColor(255, 255, 255));
        FormData fd_lblName = new FormData();
        fd_lblName.top = new FormAttachment((Control)lblNameLabel, -2, 128);
        fd_lblName.left = new FormAttachment((Control)lblNameLabel, 6);
        fd_lblName.right = new FormAttachment(0, 645);
        this.lblName.setLayoutData((Object)fd_lblName);
        this.lblName.setFont(TAHOMA_NORMAL);
        this.lblName.setForeground(ComponentsCommons.getColor((int)2));
        this.lblAcronymLabel = this.toolkit.createLabel((Composite)this, Activator.getLocalString("label.acronym.first.upper"), 256);
        this.lblAcronymLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        FormData fd_lblAcronymLabel = new FormData();
        fd_lblAcronymLabel.left = new FormAttachment((Control)lblNameLabel, 0, 16384);
        fd_lblAcronymLabel.bottom = new FormAttachment(0, 35);
        fd_lblAcronymLabel.right = new FormAttachment(0, 119);
        fd_lblAcronymLabel.top = new FormAttachment(0, 22);
        this.lblAcronymLabel.setLayoutData((Object)fd_lblAcronymLabel);
        this.lblAcronymLabel.setFont(TAHOMA_NORMAL_BOLD);
        this.lblAcronymLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblAcronym = this.toolkit.createLabel((Composite)this, "", 256);
        this.lblAcronym.setBackground(SWTResourceManager.getColor(255, 255, 255));
        FormData fd_lblAcronym = new FormData();
        fd_lblAcronym.top = new FormAttachment((Control)this.lblAcronymLabel, -2, 128);
        fd_lblAcronym.left = new FormAttachment(0, 124);
        this.lblAcronym.setLayoutData((Object)fd_lblAcronym);
        this.lblAcronym.setFont(TAHOMA_NORMAL_PLUS);
        this.lblAcronym.setForeground(ComponentsCommons.getColor((int)2));
        this.lblDateLabel = new Label((Composite)this, 256);
        fd_lblAcronym.right = new FormAttachment((Control)this.lblDateLabel, -6);
        FormData fd_lblDateLabel = new FormData();
        fd_lblDateLabel.left = new FormAttachment(0, 360);
        fd_lblDateLabel.top = new FormAttachment((Control)this.lblName, 8);
        this.lblDateLabel.setLayoutData((Object)fd_lblDateLabel);
        this.lblDateLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblDateLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblDateLabel.setFont(TAHOMA_NORMAL_BOLD);
        this.lblDateLabel.setText(Activator.getLocalString("label.date.first.upper"));
        this.lblDate = new Label((Composite)this, 256);
        FormData fd_lblDate = new FormData();
        fd_lblDate.top = new FormAttachment((Control)this.lblName, 6);
        fd_lblDate.left = new FormAttachment((Control)this.lblDateLabel, 7);
        fd_lblDate.right = new FormAttachment((Control)this.lblName, 0, 131072);
        this.lblDate.setLayoutData((Object)fd_lblDate);
        this.lblDate.setFont(TAHOMA_NORMAL_PLUS);
        this.lblDate.setForeground(ComponentsCommons.getColor((int)2));
        this.lblDate.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblSourceLabel = new Label((Composite)this, 256);
        FormData fd_lblSourceLabel = new FormData();
        fd_lblSourceLabel.top = new FormAttachment((Control)this.lblAcronymLabel, 7);
        fd_lblSourceLabel.right = new FormAttachment((Control)lblNameLabel, 0, 131072);
        fd_lblSourceLabel.left = new FormAttachment((Control)lblNameLabel, 0, 16384);
        this.lblSourceLabel.setLayoutData((Object)fd_lblSourceLabel);
        this.lblSourceLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblSourceLabel.setFont(TAHOMA_NORMAL_BOLD);
        this.lblSourceLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblSourceLabel.setText(Activator.getLocalString("label.data.source"));
        this.lblSource = new Label((Composite)this, 256);
        FormData fd_lblSource = new FormData();
        fd_lblSource.top = new FormAttachment((Control)this.lblAcronym, 6);
        fd_lblSource.left = new FormAttachment((Control)this.lblName, 0, 16384);
        fd_lblSource.right = new FormAttachment(100, -5);
        this.lblSource.setLayoutData((Object)fd_lblSource);
        this.lblSource.setFont(TAHOMA_NORMAL_PLUS);
        this.lblSource.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblSource.setForeground(ComponentsCommons.getColor((int)2));
        this.lblUrlLabel = new Label((Composite)this, 256);
        fd_lblSourceLabel.bottom = new FormAttachment((Control)this.lblUrlLabel, -6);
        FormData fd_lblUrlLabel = new FormData();
        fd_lblUrlLabel.top = new FormAttachment(0, 61);
        fd_lblUrlLabel.left = new FormAttachment((Control)lblNameLabel, 0, 16384);
        fd_lblUrlLabel.right = new FormAttachment(0, 119);
        this.lblUrlLabel.setLayoutData((Object)fd_lblUrlLabel);
        this.lblUrlLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblUrlLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblUrlLabel.setFont(TAHOMA_NORMAL_BOLD);
        this.lblUrlLabel.setText(Activator.getLocalString("label.url.all.upper"));
        this.lblUrl = new Label((Composite)this, 256);
        FormData fd_lblUrl = new FormData();
        fd_lblUrl.top = new FormAttachment((Control)this.lblUrlLabel, -2, 128);
        fd_lblUrl.left = new FormAttachment((Control)this.lblName, 0, 16384);
        fd_lblUrl.right = new FormAttachment(100, -5);
        this.lblUrl.setLayoutData((Object)fd_lblUrl);
        this.lblUrl.setFont(TAHOMA_NORMAL_PLUS);
        this.lblUrl.setForeground(ComponentsCommons.getColor((int)2));
        this.lblUrl.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblDescriptionLabel = this.toolkit.createLabel((Composite)this, Activator.getLocalString("label.description.first.upper"), 256);
        fd_lblUrlLabel.bottom = new FormAttachment((Control)this.lblDescriptionLabel, -6);
        this.lblDescriptionLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        FormData fd_lblDescriptionLabel = new FormData();
        fd_lblDescriptionLabel.left = new FormAttachment((Control)lblNameLabel, 0, 16384);
        fd_lblDescriptionLabel.top = new FormAttachment(0, 80);
        fd_lblDescriptionLabel.bottom = new FormAttachment(0, 390);
        fd_lblDescriptionLabel.right = new FormAttachment(0, 119);
        this.lblDescriptionLabel.setLayoutData((Object)fd_lblDescriptionLabel);
        this.lblDescriptionLabel.setFont(TAHOMA_NORMAL_BOLD);
        this.lblDescriptionLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblDescription = this.toolkit.createLabel((Composite)this, "", 320);
        this.lblDescription.setBackground(SWTResourceManager.getColor(255, 255, 255));
        FormData fd_lblDescription = new FormData();
        fd_lblDescription.bottom = new FormAttachment(100, -10);
        fd_lblDescription.top = new FormAttachment((Control)this.lblUrl, 8);
        fd_lblDescription.right = new FormAttachment(100, -6);
        fd_lblDescription.left = new FormAttachment((Control)this.lblDescriptionLabel, 5);
        this.lblDescription.setLayoutData((Object)fd_lblDescription);
        this.lblDescription.setFont(TAHOMA_NORMAL_PLUS);
        this.lblDescription.setForeground(ComponentsCommons.getColor((int)2));
    }

    public void renderDataset(Dataset ds) {
        if (ds != null) {
            this.lblName.setText(CoreUtils.getCurrentLang((MultilingualString)ds.getName(), (String)Activator.getLanguage()));
            this.lblAcronym.setText(ds.getAcronym());
            this.lblDescription.setText(CoreUtils.getCurrentLang((MultilingualString)ds.getDescription(), (String)Activator.getLanguage()));
            this.lblUrl.setText(ds.getUrl() != null ? ds.getUrl() : "");
            this.lblDate.setText(ds.getVersion().getDate() != null ? ds.getVersion().getDate().toString() : "");
            this.lblSource.setText(ds.getDataSource() != null ? ds.getDataSource().getName() : "");
        } else {
            this.lblName.setText("");
            this.lblAcronym.setText("");
            this.lblDescription.setText("");
            this.lblUrl.setText("");
            this.lblDate.setText("");
            this.lblSource.setText("");
        }
    }
}

