/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.edit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.export.CsvViewExporter;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettingsDialog;
import org.fao.fi.fishstat.gui.handler.base.AbstractHandlerWorkspaces;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class SaveCsvHandler
extends AbstractHandlerWorkspaces {
    public static final String ID = "org.fao.fi.fishstat.gui.command.edit.csv.save.details";
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ExportSettingsDialog dialog;
        int result;
        MultiTableView currentView = (MultiTableView)ApplicationWorkbenchAdvisor.getApplicationAdvisor().getLastActiveDoubleTableView();
        ExportSettings exportSettings = new ExportSettings(this.ps);
        if (this.ps.getBoolean("export.csv.askconfirm") && (result = (dialog = new ExportSettingsDialog(Activator.getDefault().getWorkbench().getDisplay().getActiveShell(), exportSettings)).open()) == 1) {
            return null;
        }
        CsvViewExporter exporter = new CsvViewExporter(currentView, exportSettings);
        boolean terminated = false;
        exporter.setSeparator(Character.valueOf(','));
        exporter.setTextQualifier(Character.valueOf('\"'));
        while (!terminated) {
            FileDialog filedlg = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
            filedlg.setFilterExtensions(new String[]{"*.csv"});
            filedlg.setFilterPath(System.getProperty("user.home"));
            String filepath = filedlg.open();
            if (filepath == null) {
                return null;
            }
            try {
                File file = new File(filepath);
                if (!file.exists()) {
                    exporter.setWriter(new FileWriter(file));
                    terminated = true;
                    continue;
                }
                if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"warning", (String)"This file already exists. Do you want to overwrite it?")) {
                    file.delete();
                    try {
                        exporter.setWriter(new FileWriter(new File(filepath)));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                    terminated = true;
                    continue;
                }
                terminated = false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (NullPointerException e) {
                terminated = true;
            }
        }
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)exporter);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Export done", (String)(String.valueOf(Integer.toString(exporter.getExportSize())) + " rows have been saved"));
        exporter.close();
        return null;
    }

    @Override
    public void updateEnablement(WorkspacesManager wsm) {
        this.setBaseEnabled(wsm.hasCurrentWorkspace() && GuiCoreActivator.getDefault().getRegistry().getOpenSessions().size() >= 1);
    }
}

