/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.beans.Beans;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.multitable.DimensionTableLabelProvider;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableAbstractViewer;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedContentProvider;

public class DimensionTableViewer
extends MultiTableAbstractViewer
implements SelectionListener {
    private TimeSeriesProperties timeSeriesProperties;
    private TableColumn[] columns;
    private DimensionTableLabelProvider labelProvider;
    private int i;

    public DimensionTableViewer(Composite parent, int style, GuiSession session) {
        super(parent, style);
        this.session = session;
        this.labelProvider = new DimensionTableLabelProvider((Session)session);
        if (!Beans.isDesignTime()) {
            this.timeSeriesProperties = session.getTimeseriesProperties();
        }
        if (this.timeSeriesProperties != null) {
            this.table = this.getTable();
            this.initComponent();
            this.setContentProvider((IContentProvider)new UnifiedContentProvider());
        }
    }

    private void initComponent() {
        this.setUseHashlookup(true);
        this.table.getVerticalBar().setEnabled(false);
        this.table.getVerticalBar().setVisible(false);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getHorizontalBar().setVisible(true);
        this.rebuildTable();
    }

    @Override
    protected void rebuildTable() {
        this.getTable().setVisible(false);
        if (this.timeSeriesProperties != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (DimensionTableViewer.this.columns != null) {
                        int i = 0;
                        while (i < DimensionTableViewer.this.columns.length) {
                            if (DimensionTableViewer.this.columns[i] != null && !DimensionTableViewer.this.columns[i].isDisposed()) {
                                DimensionTableViewer.this.columns[i].dispose();
                            }
                            ++i;
                        }
                    }
                }
            });
            final FSDimensionColumnDescriptor[] descriptors = this.session.getSessionMetadata().getAllDimColumnDescriptors();
            this.columns = new TableColumn[descriptors.length + 1];
            this.columns[0] = new TableColumn(this.getTable(), 16384);
            this.columns[0].setResizable(false);
            this.i = 1;
            while (this.i < this.columns.length) {
                TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this, 0);
                tableViewerColumn.setLabelProvider((CellLabelProvider)this.labelProvider);
                this.columns[this.i] = tableViewerColumn.getColumn();
                this.columns[this.i].setMoveable(true);
                this.columns[this.i].setText(this.getColumnHeader(this.i));
                this.columns[this.i].setToolTipText(this.getColumnTooltip(this.i));
                this.columns[this.i].setWidth(120);
                new MultiTableAbstractViewer.ColumnViewerSorter(this, (ColumnViewer)this, this.columns[this.i], this.i - 1){
                    HashMap<ReferenceObject, Object> cache;
                    {
                        super(multiTableAbstractViewer, $anonymous0, $anonymous1, $anonymous2);
                        this.cache = new HashMap();
                    }

                    @Override
                    protected int doCompare(Viewer viewer, Object e1, Object e2) {
                        Object o2;
                        ReferenceObject ro2;
                        ReferenceObject ro1 = ((ObservationSeries)e1).getKey(descriptors[this.idx].getDimensionIdx());
                        if (ro1.equals(ro2 = ((ObservationSeries)e2).getKey(descriptors[this.idx].getDimensionIdx()))) {
                            return 0;
                        }
                        if (ro1 == ReferenceObject.OTHERS) {
                            return this.direction;
                        }
                        if (ro2 == ReferenceObject.OTHERS) {
                            return -1 * this.direction;
                        }
                        Object o1 = this.calcSorter(ro1);
                        if (o1 == (o2 = this.calcSorter(ro2))) {
                            return 0;
                        }
                        if (o1 == null) {
                            return this.direction;
                        }
                        if (o2 == null) {
                            return -1 * this.direction;
                        }
                        return o1.toString().compareTo(o2.toString());
                    }

                    private Object calcSorter(ReferenceObject ro) {
                        if (this.cache.containsKey(ro)) {
                            return this.cache.get(ro);
                        }
                        String res = descriptors[this.idx].hasRelationship() ? CoreUtils.getTextualValue((ReferenceObject)CoreUtils.calcColumnReferenceObject((FSDimensionColumnDescriptor)descriptors[this.idx], (ReferenceObject)ro), (FSDimensionColumnDescriptor)descriptors[this.idx], (String)Activator.getLanguage()) : CoreUtils.getTextualValue((ReferenceObject)ro, (FSDimensionColumnDescriptor)descriptors[this.idx], (String)Activator.getLanguage());
                        this.cache.put(ro, res);
                        return res;
                    }
                };
                ++this.i;
            }
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int[] positions = ((Table)e.widget).getSelectionIndices();
                for (MultiTableAbstractViewer tableViewer : DimensionTableViewer.this.getParallelTables()) {
                    if (tableViewer.getColumnsCount() <= 0) continue;
                    tableViewer.getTable().setSelection(positions[0]);
                }
            }
        });
        this.getTable().setVisible(true);
    }

    @Override
    protected String getColumnHeader(int column) {
        if (column == 0) {
            return "";
        }
        FSDimensionColumnDescriptor columnDescriptor = this.session.getSessionMetadata().getDimColumnDescriptor(column - 1);
        String str_dimension = columnDescriptor.getDimension() != null ? CoreUtils.getCurrentLangName((Object)columnDescriptor.getDimension(), (String)Activator.getLanguage()) : "";
        String str_concept = columnDescriptor.getConcept() != null ? CoreUtils.getCurrentLangName((Object)columnDescriptor.getConcept(), (String)Activator.getLanguage()) : "";
        return String.valueOf(str_dimension) + " (" + str_concept + ")";
    }

    @Override
    protected String getColumnTooltip(int column) {
        if (column == 0) {
            return null;
        }
        FSDimensionColumnDescriptor columnDescriptor = this.session.getSessionMetadata().getDimColumnDescriptor(column - 1);
        String str_attribute = columnDescriptor.getAttribute() != null ? CoreUtils.getCurrentLangName((Object)columnDescriptor.getAttribute(), (String)Activator.getLanguage()) : "";
        return str_attribute;
    }

    @Override
    protected void adjournLastFocusEntity(FocusEntity entity) {
        int[] coord = this.getLastClickedCell();
        if (coord != null) {
            ObservationSeries obs = (ObservationSeries)this.getElementAt(coord[0]);
            try {
                FSDimensionColumnDescriptor dsc = this.session.getSessionMetadata().getDimColumnDescriptor(coord[1] - 1);
                ReferenceObject ro = CoreUtils.calcColumnReferenceObject((FSDimensionColumnDescriptor)dsc, (ReferenceObject)obs.getKey(dsc.getDimensionIdx()));
                entity.setColumnDescriptor((Object)dsc);
                entity.setEntity((Object)ro);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui.components", "DimensionTableViewer.getPointedObject", (Throwable)e));
            }
        }
        entity.setSource(1);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }
}

