/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.csv.test;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceCSVService;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceRelationshipCSVMetadata;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.junit.BeforeClass;
import org.junit.Test;

public class SpeciesRelationshipCSVTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    @Test
    public void testLoadFamilyRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("FAMILY_SPECIES");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        metadata.setParentHeader("ITEM_GRP");
        metadata.setChildHeader("ITEM_MEMB");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_family_species.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadOrderRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("ORDER_SPECIES");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        metadata.setParentHeader("ITEM_GRP");
        metadata.setChildHeader("ITEM_MEMB");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_order_species.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadMainGroupRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("MAIN_GROUP_SPECIES");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        metadata.setParentHeader("ITEM_GRP");
        metadata.setChildHeader("ITEM_MEMB");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_main_group_species.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadOrderFamilyRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("ORDER_FAMILY");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_order_family.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadMainGroupOrderRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("MAIN_GROUP_ORDER");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_main_group_order.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadIsscaapDivisionGroupRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("ISSCAAP_DIVISION_ISSCAAP_GROUP");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        metadata.setParentHeader("ITEM_GRP");
        metadata.setChildHeader("ITEM_MEMB");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_isscaap_div_isscaap_group.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadFaostatGroupRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("FAOSTAT_GROUP_SPECIES");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        metadata.setParentHeader("ITEM_GRP");
        metadata.setChildHeader("ITEM_MEMB");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_faostat_grp_species.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadIsscaapDivisionRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("ISSCAAP_DIVISION_SPECIES");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        metadata.setParentHeader("ITEM_GRP");
        metadata.setChildHeader("ITEM_MEMB");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_isscaap_div_species.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadIsscaapGroupRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("ISSCAAP_GROUP_SPECIES");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        metadata.setParentHeader("ITEM_GRP");
        metadata.setChildHeader("ITEM_MEMB");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/rel_isscaap_group_species.csv"))), metadata, true, null);
    }
}

