/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import java.util.HashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;

public class IDAttribute
implements Attribute {
    public static final MultilingualString NAME = new MultilingualString((Map)new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("en", "Identifier");
            this.put("fr", "Identifiant");
            this.put("es", "Identificador");
        }
    });
    public static final MultilingualString DESCRIPTION = new MultilingualString((Map)new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("en", "Identifier");
            this.put("fr", "Identifiant");
            this.put("es", "Identificador");
        }
    });
    private Concept concept;

    public IDAttribute(Concept concept) {
        if (concept == null) {
            throw new IllegalArgumentException("Concept can not be null");
        }
        this.concept = concept;
    }

    @Override
    public String getAcronym() {
        return "ID";
    }

    @Override
    public Concept getConcept() throws ReferenceServiceException {
        return this.concept;
    }

    @Override
    public MultilingualString getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Identifier getId() {
        return Identifier.NULL_ID;
    }

    @Override
    public MultilingualString getName() {
        return NAME;
    }

    @Override
    public short getScale() {
        return 0;
    }

    @Override
    public short getSize() {
        return 20;
    }

    @Override
    public AttributeType getType() {
        return AttributeType.STRING;
    }

    @Override
    public boolean isCodeAttribute() {
        return true;
    }

    @Override
    public boolean isNameAttribute() {
        return false;
    }

    @Override
    public void setCodeAttribute(boolean value) throws ReferenceServiceException {
        throw new UnsupportedOperationException("Identifier attribute is unmodifiable");
    }

    @Override
    public void setDescription(MultilingualString description) throws ReferenceServiceException {
        throw new UnsupportedOperationException("Identifier attribute is unmodifiable");
    }

    @Override
    public void setName(MultilingualString name) throws ReferenceServiceException {
        throw new UnsupportedOperationException("Identifier attribute is unmodifiable");
    }

    @Override
    public void setNameAttribute(boolean value) throws ReferenceServiceException {
        throw new UnsupportedOperationException("Identifier attribute is unmodifiable");
    }

    @Override
    public void setType(AttributeType type) throws ReferenceServiceException {
        throw new UnsupportedOperationException("Identifier attribute is unmodifiable");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.concept == null ? 0 : this.concept.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IDAttribute)) {
            return false;
        }
        IDAttribute other = (IDAttribute)obj;
        return !(this.concept == null ? other.concept != null : !this.concept.equals(other.concept));
    }

    public String toString() {
        return this.getAcronym();
    }
}

