/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;

public class CalculatedMeasureDefinitionImpl
implements CalculatedMeasureDefinition {
    private String name;
    private Function function;
    private Map<Parameter, String> parameters;
    private double min;
    private double max;
    private Set<MeasureStatus> skipStatus;
    private List<ObservationPeriod> periods;

    public CalculatedMeasureDefinitionImpl(String name) {
        this.name = name;
        this.min = Double.NEGATIVE_INFINITY;
        this.max = Double.POSITIVE_INFINITY;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public double getMaxValue() {
        return this.max;
    }

    @Override
    public double getMinValue() {
        return this.min;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<Parameter, String> getParameters() {
        return this.parameters;
    }

    @Override
    public List<ObservationPeriod> getPeriods() {
        return this.periods;
    }

    @Override
    public Set<MeasureStatus> getSkipStatus() {
        return this.skipStatus;
    }

    @Override
    public void setFunction(Function function) {
        this.function = function;
    }

    @Override
    public void setMaxValue(double value) {
        this.max = value;
    }

    @Override
    public void setMinValue(double value) {
        this.min = value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParameters(Map<Parameter, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setPeriods(List<ObservationPeriod> periods) {
        this.periods = periods;
    }

    @Override
    public void setSkipStatus(Set<MeasureStatus> status) {
        this.skipStatus = status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedMeasureDefinition)) {
            return false;
        }
        CalculatedMeasureDefinition other = (CalculatedMeasureDefinition)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name).append('[').append(String.valueOf(this.function)).append(']');
        if (this.periods != null) {
            buffer.append('[');
            for (ObservationPeriod period : this.periods) {
                buffer.append(period).append(',');
            }
            buffer.append(']');
        }
        return buffer.toString();
    }
}

