/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;

public class DimensionImpl
implements Dimension {
    private Identifier identifier;
    private String acronym;
    private MultilingualString name;
    private MultilingualString description;
    private boolean observedMeasure;
    private Concept concept;
    private Attribute attribute;
    private int index;

    public DimensionImpl(Object dimension, int index) throws TimeseriesServiceException {
        try {
            this.concept = ReferenceServiceFactory.getService().getConcept((String)Commons.getDTOAttributeByAcronym((Object)dimension, (String)"CONCEPT"));
            if (this.concept != null) {
                this.attribute = this.concept.getAttribute((String)Commons.getDTOAttributeByAcronym((Object)dimension, (String)"ATTRIBUTE"));
            }
            this.acronym = (String)Commons.getDTOAttributeByAcronym((Object)dimension, (String)"ACRONYM");
            this.name = Commons.getMultilingualDTOAttribute((Object)dimension, (String)"NAME");
            this.description = Commons.getMultilingualDTOAttribute((Object)dimension, (String)"DESCRIPTION");
            this.observedMeasure = (Short)Commons.getDTOAttributeByAcronym((Object)dimension, (String)"IS_MEASURE") > 0;
            this.identifier = IdentifierHelper.instance((String)Commons.getDTOIdentifier((Object)dimension));
            this.index = index;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to instantiate dimension", e);
        }
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public MultilingualString getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 31 * result + (this.concept == null ? 0 : this.concept.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionImpl)) {
            return false;
        }
        DimensionImpl other = (DimensionImpl)obj;
        if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
            return false;
        }
        return !(this.concept == null ? other.concept != null : !this.concept.equals(other.concept));
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public MultilingualString getDescription() {
        return this.description;
    }

    @Override
    public boolean isObservedMeasure() {
        return this.observedMeasure;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dimension [identifier=").append(this.identifier).append(", acronym=").append(this.acronym).append(", name=").append(this.name).append(", description=").append(this.description).append(", observedMeasure=").append(this.observedMeasure).append(", attribute=").append(this.attribute).append(", concept=").append(this.concept).append("]");
        return builder.toString();
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

