/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.AttributeImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.CartesianProduct;
import org.fao.fi.fishstat.data.timeseries.api.impl.GenericObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.impl.ObservationSeriesImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;
import org.fao.fi.fishstat.data.timeseries.status.MeasureStatusCalculator;
import org.fao.fi.fishstat.data.timeseries.status.MeasureStatusCalculatorFactory;

public class TimeseriesImpl
implements Timeseries {
    private static final String TIMESERIES_ATTRIBUTES_WHERE = "TIMESERIES_ID = ?";
    private static Map<ReferenceObject, Set<ReferenceObject>> parentsMap = Collections.synchronizedMap(new HashMap());
    private Object timeseriesDto;
    private Dataset dataset;
    private DataSource datasource;
    private Identifier identifier;
    private Map<Attribute, String> attributes;
    private Map<MultiReferenceObject, ObservationSeries> multikeyObservationsMap;
    private Map<ReferenceObject, ObservationSeries> totals;
    private List<ObservationPeriod> periods;
    private MeasureStatusCalculator statusCalculator;
    private Map<String, CalculatedMeasureDefinition> calculatedMeasureDefinitions = Collections.synchronizedMap(new LinkedHashMap());
    private ReferenceObject topOthersMeasure;

    public TimeseriesImpl(Object series, Dataset dataset) throws TimeseriesServiceException {
        try {
            if (series == null) {
                throw new IllegalArgumentException("Expecting not null timeseries DTO");
            }
            if (dataset == null) {
                throw new IllegalArgumentException("Expecting not null timeseries meta dataset");
            }
            this.timeseriesDto = series;
            this.dataset = dataset;
            this.identifier = IdentifierHelper.instance((String)Commons.getDTOIdentifier((Object)series));
            this.statusCalculator = MeasureStatusCalculatorFactory.instance(this.getDataSource());
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to instantiare the timeseries", e);
        }
    }

    protected void setObservations(List<ObservationSeries> observations) {
        if (observations != null) {
            this.reset();
            this.multikeyObservationsMap = new LinkedHashMap<MultiReferenceObject, ObservationSeries>(observations.size());
            for (ObservationSeries series : observations) {
                this.multikeyObservationsMap.put(series.getKeys(), series);
            }
        }
    }

    @Override
    public String getAcronym() throws TimeseriesServiceException {
        try {
            return (String)Commons.getDTOAttributeByAcronym((Object)this.timeseriesDto, (String)"ACRONYM");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the acronym", e);
        }
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public MultilingualString getDescription() throws TimeseriesServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.timeseriesDto, (String)"DESCRIPTION");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the description", e);
        }
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public MultilingualString getName() throws TimeseriesServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.timeseriesDto, (String)"NAME");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the name", e);
        }
    }

    @Override
    public void setDescription(MultilingualString description) throws TimeseriesServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.timeseriesDto, (String)"DESCRIPTION", (MultilingualString)description);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the description", e);
        }
    }

    @Override
    public void setName(MultilingualString name) throws TimeseriesServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.timeseriesDto, (String)"NAME", (MultilingualString)name);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the name", e);
        }
    }

    @Override
    public DataSource getDataSource() throws TimeseriesServiceException {
        try {
            if (this.datasource == null) {
                this.datasource = new DataSource((String)Commons.getDTOAttributeByAcronym((Object)this.timeseriesDto, (String)"DATA_SOURCE"));
            }
            return this.datasource;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the data source", e);
        }
    }

    @Override
    public void setDataSource(DataSource datasource) throws TimeseriesServiceException {
        try {
            Commons.setDTOAttribute((Object)this.timeseriesDto, (String)"DATA_SOURCE", (Object)datasource.getName(), String.class);
            this.update();
            this.datasource = datasource;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the data source", e);
        }
    }

    private void update() throws TimeseriesServiceException {
        try {
            TimeseriesServiceHelper.getTsmTimeseriesDao().update(Commons.getDTOPk((Object)this.timeseriesDto), this.timeseriesDto);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to update timeseries: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(this.getId()).append("]").append("[").append(this.getAcronym()).append("]").append("[").append(this.getName()).append("]").append("[").append(this.getDescription()).append("]").append("[").append(this.getVersion()).append("]");
        return buffer.toString();
    }

    private Collection<ObservationSeries> observations() throws Exception {
        if (this.multikeyObservationsMap == null) {
            List list = TimeseriesServiceHelper.getTimeseriesDAO(this.getDataset().getAcronym(), this.getAcronym()).findAll();
            this.multikeyObservationsMap = new LinkedHashMap<MultiReferenceObject, ObservationSeries>(list.size());
            for (Object dto : list) {
                ObservationSeriesImpl series = new ObservationSeriesImpl(dto, this);
                this.multikeyObservationsMap.put(series.getKeys(), series);
            }
        }
        return this.multikeyObservationsMap.values();
    }

    private void resetTotals() {
        if (this.totals != null) {
            this.totals.clear();
            this.totals = null;
        }
    }

    @Override
    public List<ObservationSeries> getObservations() throws TimeseriesServiceException {
        try {
            return new ArrayList<ObservationSeries>(this.observations());
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get observations: " + e.getMessage(), e);
        }
    }

    @Override
    public void select(String sql, Object[] sqlParams) throws TimeseriesServiceException {
        try {
            List list = TimeseriesServiceHelper.getTimeseriesDAO(this.getDataset().getAcronym(), this.getAcronym()).findByDynamicWhere(sql, sqlParams);
            ArrayList<ObservationSeries> filtered_observations = new ArrayList<ObservationSeries>(list.size());
            for (Object dto : list) {
                ObservationSeriesImpl series = new ObservationSeriesImpl(dto, this);
                filtered_observations.add(series);
            }
            this.setObservations(filtered_observations);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get observations: " + e.getMessage(), e);
        }
    }

    private ObservationSeries createTotals(ReferenceObject object) throws Exception {
        GenericObservationSeries result = new GenericObservationSeries(this);
        Object[] total_keys_array = new ReferenceObject[this.dataset.getConcepts().size()];
        Arrays.fill(total_keys_array, object);
        MultiReferenceObject total_keys = new MultiReferenceObject((ReferenceObject[])total_keys_array);
        result.setKeys(total_keys);
        result.zeroMeasures();
        return result;
    }

    private String buildWhereClauseStatement(Selection selection) {
        ArrayList<String> in_statements = new ArrayList<String>();
        for (Concept concept : selection.dimensions()) {
            if (selection.get(concept) == null || selection.get(concept).size() <= 0) continue;
            StringBuffer ids_placeholder = new StringBuffer();
            ids_placeholder.append('(');
            int i = 0;
            while (i < selection.get(concept).size()) {
                ids_placeholder.append('?');
                if (i < selection.get(concept).size() - 1) {
                    ids_placeholder.append(',');
                }
                ++i;
            }
            ids_placeholder.append(')');
            in_statements.add(String.valueOf(concept.getAcronym()) + " IN " + ids_placeholder.toString());
        }
        StringBuffer where_clause = new StringBuffer();
        if (in_statements.size() > 0) {
            Iterator iterator = in_statements.iterator();
            while (iterator.hasNext()) {
                where_clause.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                where_clause.append(" AND ");
            }
        }
        return where_clause.toString();
    }

    private List<Object> buildWhereClauseParamenters(Selection selection) {
        ArrayList<Object> sql_params = new ArrayList<Object>();
        for (Concept concept : selection.dimensions()) {
            for (Dimension dimension : this.getDataset().getDimensions()) {
                if (!dimension.getConcept().equals(concept)) continue;
                org.fao.fi.fishstat.data.reference.api.Attribute attribute = dimension.getAttribute();
                if (selection.get(concept) == null || selection.get(concept).size() <= 0) continue;
                HashSet<Object> codes = new HashSet<Object>();
                for (ReferenceObject object : selection.get(concept)) {
                    codes.add(object.getAttribute(attribute));
                }
                sql_params.addAll(codes);
            }
        }
        return sql_params;
    }

    @Override
    public void filter(Selection selection) throws TimeseriesServiceException {
        if (selection == null || selection.dimensions().size() == 0) {
            return;
        }
        if (!this.getDataset().getConcepts().containsAll(selection.dimensions())) {
            throw new TimeseriesServiceException("Selection dimensions not compatible with dataset definition");
        }
        try {
            Iterator<ObservationSeries> iterator = this.observations().iterator();
            while (iterator.hasNext()) {
                ObservationSeries series = iterator.next();
                boolean selected = true;
                ReferenceObject[] referenceObjectArray = series.getKeys().elements();
                int n = referenceObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceObject key = referenceObjectArray[n2];
                    Set<ReferenceObject> dimension_selection = selection.get(key.getConcept());
                    if (dimension_selection != null && !dimension_selection.contains(key)) {
                        selected = false;
                        break;
                    }
                    ++n2;
                }
                if (selected) continue;
                iterator.remove();
            }
            this.resetTotals();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to filter: " + e.getMessage(), e);
        }
    }

    private void aggregateObservations(Selection selection) throws TimeseriesServiceException {
        if (selection == null || selection.dimensions().size() == 0) {
            return;
        }
        if (!this.getDataset().getConcepts().containsAll(selection.dimensions())) {
            throw new TimeseriesServiceException("Aggregated dimensions not compatible with dataset definition");
        }
        if (this.getDataset().getObservedMeasureDimension() != null && selection.dimensions().contains(this.getDataset().getObservedMeasureDimension().getConcept())) {
            throw new TimeseriesServiceException("The timeseries can not be aggregated on the observed measure dimension");
        }
        try {
            this.statusCalculator.reset();
            HashMap<MultiReferenceObject, ObservationSeries> aggregated_result = new HashMap<MultiReferenceObject, ObservationSeries>();
            for (ObservationSeries series : this.observations()) {
                List<MultiReferenceObject> series_aggregators = this.calculateAggregators(series, selection);
                CartesianProduct product = new CartesianProduct(series_aggregators);
                for (MultiReferenceObject multi_key : product) {
                    ObservationSeries aggregated_series = (ObservationSeries)aggregated_result.get(multi_key);
                    if (aggregated_series == null) {
                        aggregated_series = new GenericObservationSeries(this);
                        aggregated_series.setKeys(multi_key);
                        aggregated_series.setMeasures(TimeseriesServiceHelper.cloneSeriesMeasures(series.getMeasures()));
                    } else {
                        this.aggregateValues(aggregated_series, series);
                    }
                    this.aggregateStatus(aggregated_series, series);
                    aggregated_result.put(multi_key, aggregated_series);
                }
            }
            this.setObservations(new ArrayList<ObservationSeries>(aggregated_result.values()));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to aggregate: " + e.getMessage(), e);
        }
    }

    private void aggregateStatus(ObservationSeries aggregated, ObservationSeries series) {
        this.statusCalculator.calculate(aggregated, series);
    }

    private void aggregateValues(ObservationSeries aggregated, ObservationSeries series) throws Exception {
        Map<ObservationPeriod, Measure> series_measures = series.getMeasures();
        Map<ObservationPeriod, Measure> aggregated_measures = aggregated.getMeasures();
        for (Map.Entry<ObservationPeriod, Measure> measure_entry : series_measures.entrySet()) {
            Measure observation_measure = measure_entry.getValue();
            Measure aggregated_measure = aggregated_measures.get(measure_entry.getKey());
            double aggregated_value = aggregated_measure.getValue();
            aggregated_measure.setValue(aggregated_value += observation_measure.getValue());
        }
    }

    private Set<ReferenceObject> getAnyParent(ReferenceObject object) throws Exception {
        if (parentsMap.get(object) == null) {
            parentsMap.put(object, new HashSet());
            for (Relationship relationship : object.getConcept().getParentRelationships()) {
                parentsMap.get(object).addAll(relationship.getParents(object));
            }
        }
        return parentsMap.get(object);
    }

    private List<MultiReferenceObject> calculateAggregators(ObservationSeries series, Selection selection) throws Exception {
        ArrayList<MultiReferenceObject> observation_aggregators = new ArrayList<MultiReferenceObject>();
        ReferenceObject[] referenceObjectArray = series.getKeys().elements();
        int n = referenceObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceObject key = referenceObjectArray[n2];
            HashSet<ReferenceObject> aggregators = new HashSet<ReferenceObject>();
            if (selection.get(key.getConcept()) == null || selection.get(key.getConcept()).size() == 0) {
                aggregators.add(key);
            } else if (selection.get(key.getConcept()).contains(ReferenceObject.ALL)) {
                aggregators.add(ReferenceObject.ALL);
            } else {
                boolean to_be_aggregated = false;
                if (selection.get(key.getConcept()).contains(key)) {
                    aggregators.add(key);
                    to_be_aggregated = true;
                }
                for (ReferenceObject parent : this.getAnyParent(key)) {
                    if (!selection.get(key.getConcept()).contains(parent)) continue;
                    aggregators.add(parent);
                    to_be_aggregated = true;
                }
                if (!to_be_aggregated) {
                    aggregators.add(ReferenceObject.OTHERS);
                }
            }
            observation_aggregators.add(new MultiReferenceObject(aggregators));
            ++n2;
        }
        return observation_aggregators;
    }

    private Map<Attribute, String> attributes() throws Exception {
        if (this.attributes == null) {
            this.attributes = new HashMap<Attribute, String>();
            GenericDAO attribute_dao = TimeseriesServiceHelper.getTsmAttributeDao();
            List attribute_dtos = attribute_dao.findByDynamicWhere(TIMESERIES_ATTRIBUTES_WHERE, (Object[])new String[]{this.getId().stringValue()});
            if (attribute_dtos != null) {
                for (Object dto : attribute_dtos) {
                    this.attributes.put(new AttributeImpl((String)Commons.getDTOAttributeByAcronym(dto, (String)"ACRONYM"), Commons.getMultilingualDTOAttribute(dto, (String)"NAME"), Commons.getMultilingualDTOAttribute(dto, (String)"DESCRIPTION")), (String)Commons.getDTOAttributeByAcronym(dto, (String)"VALUE"));
                }
            }
        }
        return this.attributes;
    }

    @Override
    public Map<Attribute, String> getAttributes() throws TimeseriesServiceException {
        try {
            return Collections.unmodifiableMap(this.attributes());
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get series attributes", e);
        }
    }

    @Override
    public void aggregate(Selection selection) throws TimeseriesServiceException {
        this.aggregateObservations(selection);
    }

    @Override
    public void aggregate(TopCriteria criteria, ObservationPeriod period) throws TimeseriesServiceException {
        if (period == null) {
            throw new TimeseriesServiceException("top/others observation period can not be null");
        }
        if (period.compareTo(this.getFirstObservationPeriod()) < 0 || period.compareTo(this.getLastObservationPeriod()) > 0) {
            throw new TimeseriesServiceException("top/others observation period must be comprised between " + this.getFirstObservationPeriod() + " and " + this.getLastObservationPeriod() + ", found: " + period);
        }
        this.topOthers(criteria, period, null);
    }

    @Override
    public void aggregate(TopCriteria criteria, CalculatedMeasureDefinition definition) {
        if (definition == null) {
            throw new TimeseriesServiceException("top/others calculated measure definition can not be null");
        }
        if (!this.getCalculatedMeasureDefinitions().contains(definition)) {
            throw new TimeseriesServiceException("undefined calculated measure");
        }
        this.topOthers(criteria, null, definition);
    }

    private void topOthers(TopCriteria criteria, ObservationPeriod period, CalculatedMeasureDefinition definition) throws TimeseriesServiceException {
        if (criteria == null) {
            throw new TimeseriesServiceException("top/others criteria can not be null");
        }
        try {
            this.topOthersMeasure = criteria.getMeasure();
            if (this.topOthersMeasure != null && this.topOthersMeasure != ReferenceObject.ALL && this.getDataset().getObservedMeasureDimension() != null && this.getDataset().getObservedMeasureDimension().getConcept().equals(this.topOthersMeasure.getConcept())) {
                Selection selection = Selection.instance();
                selection.add(this.topOthersMeasure.getConcept(), this.topOthersMeasure);
                this.filter(selection);
            }
            if (period != null) {
                this.sort(period);
            } else {
                this.sort(definition);
            }
            ArrayList<ObservationSeries> other_observations = new ArrayList<ObservationSeries>();
            switch (criteria.getType()) {
                case TOP_RECORDS_NUMBER: {
                    double top_records_number = criteria.getValue();
                    if (top_records_number <= 0.0) {
                        throw new TimeseriesServiceException("top/others records number must be non negative");
                    }
                    if (top_records_number >= (double)this.observations().size()) {
                        top_records_number = this.observations().size();
                    }
                    int nr = 1;
                    Iterator<ObservationSeries> iterator = this.observations().iterator();
                    while (iterator.hasNext()) {
                        ObservationSeries series = iterator.next();
                        if ((double)nr > top_records_number) {
                            other_observations.add(series);
                            iterator.remove();
                        }
                        ++nr;
                    }
                    break;
                }
                case TOP_RECORDS_PERCENT: {
                    if (criteria.getValue() <= 0.0) {
                        throw new TimeseriesServiceException("top/others records percent must be non negative");
                    }
                    if (criteria.getValue() > 100.0) {
                        throw new TimeseriesServiceException("top/others records percent must be < 100");
                    }
                    if (criteria.getValue() == 100.0) break;
                    double total_value = period == null ? this.getTotals().getCalculatedMeasure(definition).getValue() : this.getTotals().getMeasure(period).getValue();
                    double percent_value = total_value / 100.0 * criteria.getValue();
                    double partial = 0.0;
                    Iterator<ObservationSeries> iterator = this.observations().iterator();
                    while (iterator.hasNext()) {
                        ObservationSeries series = iterator.next();
                        if (!((partial += period == null ? series.getCalculatedMeasure(definition).getValue() : series.getMeasure(period).getValue()) > percent_value)) continue;
                        other_observations.add(series);
                        iterator.remove();
                    }
                    break;
                }
                case TOP_RECORDS_VALUE: {
                    Iterator<ObservationSeries> iterator = this.observations().iterator();
                    while (iterator.hasNext()) {
                        double value;
                        ObservationSeries series = iterator.next();
                        double d = value = period == null ? series.getCalculatedMeasure(definition).getValue() : series.getMeasure(period).getValue();
                        if (!(value < criteria.getValue())) continue;
                        other_observations.add(series);
                        iterator.remove();
                    }
                    break;
                }
                default: {
                    throw new TimeseriesServiceException("Unknown top/others criteria: " + criteria);
                }
            }
            ObservationSeries total_others = this.createTotals(ReferenceObject.OTHERS);
            this.sumMeasures(total_others, other_observations, this.topOthersMeasure);
            this.multikeyObservationsMap.put(total_others.getKeys(), total_others);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to apply top/others criteria", e);
        }
    }

    @Override
    public void sort(ObservationPeriod period) throws TimeseriesServiceException {
        try {
            this.setObservations(TimeseriesServiceHelper.sort(new ArrayList<ObservationSeries>(this.observations()), period));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to sort the timeseries", e);
        }
    }

    @Override
    public void sort(CalculatedMeasureDefinition definition) throws TimeseriesServiceException {
        try {
            this.setObservations(TimeseriesServiceHelper.sort(new ArrayList<ObservationSeries>(this.observations()), definition));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to sort the timeseries", e);
        }
    }

    @Override
    public ObservationPeriod getFirstObservationPeriod() throws TimeseriesServiceException {
        try {
            return new ObservationPeriod((String)Commons.getDTOAttributeByAcronym((Object)this.timeseriesDto, (String)"FIRST_PERIOD"));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get first period", e);
        }
    }

    @Override
    public ObservationPeriod getLastObservationPeriod() throws TimeseriesServiceException {
        try {
            return new ObservationPeriod((String)Commons.getDTOAttributeByAcronym((Object)this.timeseriesDto, (String)"LAST_PERIOD"));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get last period", e);
        }
    }

    @Override
    public List<ObservationPeriod> getObservationPeriods() throws TimeseriesServiceException {
        if (this.periods == null) {
            this.periods = TimeseriesServiceHelper.calculateObservationPeriods(this.getFirstObservationPeriod(), this.getLastObservationPeriod(), this.getTimeResolution());
        }
        return Collections.unmodifiableList(this.periods);
    }

    @Override
    public TimeResolution getTimeResolution() throws TimeseriesServiceException {
        try {
            return TimeResolution.valueOf((String)Commons.getDTOAttributeByAcronym((Object)this.timeseriesDto, (String)"TIME_RESOLUTION"));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get time resolution", e);
        }
    }

    @Override
    public ObservationSeries getTotals(ReferenceObject measure) throws TimeseriesServiceException {
        if (measure != null && measure != ReferenceObject.ALL && !this.getDataset().getObservedMeasureDimension().getConcept().equals(measure.getConcept())) {
            throw new TimeseriesServiceException("Provided measure object is not a valid observed measure for the dataset");
        }
        if (measure == null) {
            measure = ReferenceObject.ALL;
        }
        try {
            ObservationSeries result;
            if (this.totals == null) {
                this.totals = Collections.synchronizedMap(new HashMap());
            }
            if ((result = this.totals.get(measure)) == null) {
                result = this.calculateTotals(measure);
                this.totals.put(measure, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to calculate totals", e);
        }
    }

    @Override
    public ObservationSeries getTotals() {
        return this.getTotals(ReferenceObject.ALL);
    }

    private ObservationSeries calculateTotals(ReferenceObject measure) throws Exception {
        ObservationSeries totals_series = this.createTotals(ReferenceObject.ALL);
        return this.sumMeasures(totals_series, this.observations(), measure);
    }

    private ObservationSeries sumMeasures(ObservationSeries totalSeries, Collection<ObservationSeries> observations, ReferenceObject measure) throws Exception {
        for (ObservationSeries series : observations) {
            if (measure == null || measure.equals(ReferenceObject.ALL)) {
                this.sumMeasure(totalSeries, series);
                continue;
            }
            Dimension observed_measure_dimension = this.getDataset().getObservedMeasureDimension();
            if (observed_measure_dimension == null) {
                this.sumMeasure(totalSeries, series);
                continue;
            }
            int measure_dimension_index = observed_measure_dimension.getIndex();
            ReferenceObject series_measure = series.getKey(measure_dimension_index);
            if (measure.equals(series_measure)) {
                this.sumMeasure(totalSeries, series);
                continue;
            }
            if (!ReferenceObject.OTHERS.equals(series_measure) || !measure.equals(this.topOthersMeasure)) continue;
            this.sumMeasure(totalSeries, series);
        }
        totalSeries.resetCalculatedMeasures();
        return totalSeries;
    }

    private ObservationSeries sumMeasure(ObservationSeries totalSeries, ObservationSeries series) throws Exception {
        Map<ObservationPeriod, Measure> total_measures = totalSeries.getMeasures();
        for (Map.Entry<ObservationPeriod, Measure> entry : series.getMeasures().entrySet()) {
            Measure measure = total_measures.get(entry.getKey());
            measure.setValue(measure.getValue() + entry.getValue().getValue());
            measure.setStatus(MeasureStatus.NOT_SPECIFIED);
        }
        return totalSeries;
    }

    @Override
    public void reset() throws TimeseriesServiceException {
        if (this.multikeyObservationsMap != null) {
            this.multikeyObservationsMap.clear();
            this.multikeyObservationsMap = null;
        }
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        if (this.totals != null) {
            this.totals.clear();
            this.totals = null;
        }
        if (this.periods != null) {
            this.periods.clear();
            this.periods = null;
        }
        this.topOthersMeasure = null;
        System.gc();
    }

    @Override
    public boolean compatible(ObservationSeries series) throws TimeseriesServiceException {
        try {
            return TimeseriesServiceHelper.compatible(this, series);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to compare series attributes", e);
        }
    }

    @Override
    public void add(ObservationSeries series) throws TimeseriesServiceException {
        try {
            if (series == null) {
                throw new IllegalArgumentException("Series can not be null");
            }
            if (!this.compatible(series)) {
                throw new IllegalArgumentException("Incompatible series");
            }
            this.addSeriesEntry(series, null);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to add the series", e);
        }
    }

    @Override
    public void add(List<ObservationSeries> list) throws TimeseriesServiceException {
        Identifier id = null;
        try {
            if (list == null) {
                throw new IllegalArgumentException("Series list can not be null");
            }
            for (ObservationSeries series : list) {
                if (series == null) {
                    throw new IllegalArgumentException("Series can not be null");
                }
                if (this.compatible(series)) continue;
                throw new IllegalArgumentException("Incompatible series");
            }
            Class<?> c = TimeseriesServiceHelper.getTimeseriesDTOClass(this.getDataset().getAcronym(), this.getAcronym());
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            GenericDAO object_dao = TimeseriesServiceHelper.getTimeseriesDAO(this.getDataset().getAcronym(), this.getAcronym());
            List<Dimension> dimensions = this.getDataset().getDimensions();
            id = IdentifierHelper.instance((String)object_dao.generateId());
            for (ObservationSeries series : list) {
                Object dto = constructor.newInstance(new Object[0]);
                Commons.setDTOIdentifier(dto, (String)id.stringValue());
                for (Dimension dimension : dimensions) {
                    Concept concept = dimension.getConcept();
                    org.fao.fi.fishstat.data.reference.api.Attribute attribute = dimension.getAttribute();
                    ReferenceObject object = (ReferenceObject)series.getKeys().asMap().get(concept);
                    Commons.setDTOAttribute(dto, (String)concept.getAcronym(), (Object)object.getAttribute(attribute), (Class)attribute.getType().getRuntimeType());
                }
                for (Map.Entry entry : series.getMeasures().entrySet()) {
                    Commons.setDTOAttribute(dto, (String)("VALUE_" + ((ObservationPeriod)entry.getKey()).toString()), (Object)((Measure)entry.getValue()).getValue(), Double.class);
                    Commons.setDTOAttribute(dto, (String)("SYMBOL_" + ((ObservationPeriod)entry.getKey()).toString()), (Object)((Measure)entry.getValue()).getStatus().toString(), String.class);
                }
                object_dao.insert(dto);
                id = IdentifierHelper.next((Identifier)id);
            }
        }
        catch (Exception e) {
            if (id != null) {
                System.out.println("ERROR: persisting series: " + id);
            }
            throw new TimeseriesServiceException("Unable to add the series", e);
        }
    }

    @Override
    public void remove(ObservationSeries series) throws TimeseriesServiceException {
        try {
            List<Object> parameters;
            if (series == null) {
                throw new IllegalArgumentException("Series can not be null");
            }
            GenericDAO object_dao = TimeseriesServiceHelper.getTimeseriesDAO(this.getDataset().getAcronym(), this.getAcronym());
            Selection selection = Selection.instance();
            ReferenceObject[] referenceObjectArray = series.getKeys().elements();
            int n = referenceObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceObject key = referenceObjectArray[n2];
                selection.add(key.getConcept(), key);
                ++n2;
            }
            String where = this.buildWhereClauseStatement(selection);
            List dtos = object_dao.findByDynamicWhere(where, (parameters = this.buildWhereClauseParamenters(selection)).toArray());
            if (dtos != null && dtos.size() == 1) {
                object_dao.delete(Commons.getDTOPk(dtos.get(0)));
                this.reset();
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to remove the series", e);
        }
    }

    private Identifier addSeriesEntry(ObservationSeries series, Identifier id) throws Exception {
        Class<?> c = TimeseriesServiceHelper.getTimeseriesDTOClass(this.getDataset().getAcronym(), this.getAcronym());
        Constructor<?> constructor = c.getConstructor(new Class[0]);
        Object dto = constructor.newInstance(new Object[0]);
        GenericDAO object_dao = TimeseriesServiceHelper.getTimeseriesDAO(this.getDataset().getAcronym(), this.getAcronym());
        Identifier result = null;
        result = id == null ? IdentifierHelper.instance((String)object_dao.generateId()) : id;
        Commons.setDTOIdentifier(dto, (String)result.stringValue());
        for (Dimension dimension : this.getDataset().getDimensions()) {
            Concept concept = dimension.getConcept();
            org.fao.fi.fishstat.data.reference.api.Attribute attribute = dimension.getAttribute();
            ReferenceObject object = (ReferenceObject)series.getKeys().asMap().get(concept);
            Commons.setDTOAttribute(dto, (String)concept.getAcronym(), (Object)object.getAttribute(attribute), (Class)attribute.getType().getRuntimeType());
        }
        for (Map.Entry entry : series.getMeasures().entrySet()) {
            Commons.setDTOAttribute(dto, (String)("VALUE_" + ((ObservationPeriod)entry.getKey()).toString()), (Object)((Measure)entry.getValue()).getValue(), Double.class);
            Commons.setDTOAttribute(dto, (String)("SYMBOL_" + ((ObservationPeriod)entry.getKey()).toString()), (Object)((Measure)entry.getValue()).getStatus().toString(), String.class);
        }
        object_dao.insert(dto);
        this.reset();
        return result;
    }

    @Override
    public void update(ObservationSeries series) throws TimeseriesServiceException {
        try {
            List<Object> parameters;
            if (series == null) {
                throw new IllegalArgumentException("Series can not be null");
            }
            if (!this.compatible(series)) {
                throw new IllegalArgumentException("Incompatible series");
            }
            GenericDAO object_dao = TimeseriesServiceHelper.getTimeseriesDAO(this.getDataset().getAcronym(), this.getAcronym());
            Selection selection = Selection.instance();
            ReferenceObject[] referenceObjectArray = series.getKeys().elements();
            int n = referenceObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceObject key = referenceObjectArray[n2];
                selection.add(key.getConcept(), key);
                ++n2;
            }
            String where = this.buildWhereClauseStatement(selection);
            List dtos = object_dao.findByDynamicWhere(where, (parameters = this.buildWhereClauseParamenters(selection)).toArray());
            if (dtos != null && dtos.size() == 1) {
                Object dto = dtos.get(0);
                for (Map.Entry<ObservationPeriod, Measure> entry : series.getMeasures().entrySet()) {
                    Commons.setDTOAttribute(dto, (String)("VALUE_" + entry.getKey().toString()), (Object)entry.getValue().getValue(), Double.class);
                    Commons.setDTOAttribute(dto, (String)("SYMBOL_" + entry.getKey().toString()), (Object)entry.getValue().getStatus().toString(), String.class);
                }
                object_dao.update(Commons.getDTOPk(dto), dto);
                if (this.multikeyObservationsMap != null) {
                    this.multikeyObservationsMap.put(series.getKeys(), series);
                }
            }
        }
        catch (RuntimeException re) {
            throw new TimeseriesServiceException("Unable to update the series", re);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to update the series", e);
        }
    }

    @Override
    public void clean() throws TimeseriesServiceException {
        try {
            GenericDAO object_dao = TimeseriesServiceHelper.getTimeseriesDAO(this.getDataset().getAcronym(), this.getAcronym());
            object_dao.deleteAll();
            if (this.multikeyObservationsMap != null) {
                this.multikeyObservationsMap.clear();
                this.multikeyObservationsMap = null;
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to clean the timeseries", e);
        }
    }

    @Override
    public void addCalculatedMeasureDefinition(CalculatedMeasureDefinition definition) throws TimeseriesServiceException {
        try {
            if (definition == null) {
                throw new IllegalArgumentException("The calculated measure definition can not be null");
            }
            if (definition.getName() == null) {
                throw new IllegalArgumentException("The calculated measure definition name can not be null");
            }
            this.calculatedMeasureDefinitions.put(definition.getName(), definition);
            this.resetCalculatedMeasures();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to add the calculated measure definition", e);
        }
    }

    private void resetCalculatedMeasures() throws Exception {
        for (ObservationSeries series : this.observations()) {
            series.resetCalculatedMeasures();
        }
    }

    @Override
    public Collection<CalculatedMeasureDefinition> getCalculatedMeasureDefinitions() {
        return Collections.unmodifiableCollection(this.calculatedMeasureDefinitions.values());
    }

    @Override
    public void removeCalculatedMeasureDefinition(String name) throws TimeseriesServiceException {
        try {
            CalculatedMeasureDefinition removed = this.calculatedMeasureDefinitions.remove(name);
            if (removed != null) {
                this.resetCalculatedMeasures();
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to remove the calculated measure definition", e);
        }
    }

    @Override
    public CalculatedMeasureDefinition getCalculatedMeasureDefinition(String name) {
        return this.calculatedMeasureDefinitions.get(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timeseries)) {
            return false;
        }
        Timeseries other = (Timeseries)obj;
        return !(this.identifier == null ? other.getId() != null : !this.identifier.equals(other.getId()));
    }

    @Override
    public void addCalculatedMeasureDefinitions(Collection<CalculatedMeasureDefinition> definitions) {
        try {
            if (definitions != null && definitions.size() > 0) {
                for (CalculatedMeasureDefinition definition : definitions) {
                    if (definition.getName() == null) {
                        throw new IllegalArgumentException("The calculated measure definition name can not be null");
                    }
                    this.calculatedMeasureDefinitions.put(definition.getName(), definition);
                }
                this.resetCalculatedMeasures();
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to add the calculated measure definitions", e);
        }
    }

    @Override
    public void removeCalculatedMeasureDefinition(CalculatedMeasureDefinition definition) {
        try {
            CalculatedMeasureDefinition removed;
            if (definition != null && (removed = this.calculatedMeasureDefinitions.remove(definition.getName())) != null) {
                this.resetCalculatedMeasures();
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to remove the calculated measure definition", e);
        }
    }

    @Override
    public void removeCalculatedMeasureDefinitions(Collection<CalculatedMeasureDefinition> definitions) {
        try {
            if (definitions != null && definitions.size() > 0) {
                for (CalculatedMeasureDefinition definition : definitions) {
                    if (definition == null) continue;
                    this.calculatedMeasureDefinitions.put(definition.getName(), definition);
                }
                this.resetCalculatedMeasures();
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to remove the calculated measure definitions", e);
        }
    }

    @Override
    public Collection<ReferenceObject> getReferencedObjects(Dimension dimension) {
        if (dimension == null) {
            throw new TimeseriesServiceException("The dimension can not be null");
        }
        if (!this.getDataset().getDimensions().contains(dimension)) {
            throw new TimeseriesServiceException("It is not a timeseries dimension: " + dimension);
        }
        try {
            Concept concept = dimension.getConcept();
            HashSet<ReferenceObject> referenced = new HashSet<ReferenceObject>();
            for (ObservationSeries series : this.observations()) {
                referenced.add(series.getKey(concept));
            }
            return referenced;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to retrieve distinct referenced objects", e);
        }
    }

    @Override
    public Collection<ReferenceObject> getAllReferencedObjects(Dimension dimension) {
        if (dimension == null) {
            throw new TimeseriesServiceException("The dimension can not be null");
        }
        if (!this.getDataset().getDimensions().contains(dimension)) {
            throw new TimeseriesServiceException("It is not a timeseries dimension: " + dimension);
        }
        return TimeseriesServiceHelper.getAllReferencedObjects(this, dimension);
    }

    @Override
    public int getRowCount() throws TimeseriesServiceException {
        return TimeseriesServiceHelper.getRowCount(this);
    }

    @Override
    public ObservationSeries create() {
        return new GenericObservationSeries(this);
    }

    public Version getVersion() throws TimeseriesServiceException {
        try {
            return VersionHelper.getVersion((Object)this.timeseriesDto);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get version", (Throwable)e);
        }
    }

    public void setVersion(Version version) throws TimeseriesServiceException {
        try {
            VersionHelper.setVersion((Object)this.timeseriesDto, (Version)version);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set version", (Throwable)e);
        }
    }
}

