/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.test;

import java.util.List;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.common.utils.Timer;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinitionFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.FunctionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GlobalAquacultureProductionTestCase {
    private static final long FILTER_BY_CONTINENT_MAX_TIME = 6500L;
    private static final long FILTER_BY_FRESHWATER_MAX_TIME = 6500L;
    private static final int GROUP_BY_CONTINENT_MAX_TIME = 6500;
    private static final long TOTALS_MAX_TIME = 3000L;
    private static final long TOP_OTHERS_MAX_TIME = 10000L;
    private static Dataset global_aquaculture;
    private static Timeseries global_aquaculture_production;

    @BeforeClass
    public static void setUpClass() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
        global_aquaculture = TimeseriesServiceFactory.getService().getDataset("GLOBAL_AQUACULTURE");
        global_aquaculture_production = global_aquaculture.getTimeseries("PRODUCTION");
    }

    @Before
    public void setUpTest() throws Exception {
        global_aquaculture_production.reset();
        System.out.println("getting observations...");
        Timer.start();
        global_aquaculture_production.getObservations();
        Timer.stop();
        System.out.println("ready in " + Timer.timeElapsed() + "msec");
    }

    @Test
    public void testCalculateTotals() throws Exception {
        System.out.println("calculating totals...");
        for (ReferenceObject measure : global_aquaculture_production.getReferencedObjects(global_aquaculture.getObservedMeasureDimension())) {
            Timer.start();
            ObservationSeries result = global_aquaculture_production.getTotals(measure);
            Timer.stop();
            System.out.println("calculated [" + measure.getAttribute("CODE") + "] totals in " + Timer.timeElapsed() + "msec\n" + result);
            Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate totals"), (Timer.timeElapsed() < 3000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFilterGlobalAquacultureProductionByEuropeanCountries() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept continent = ReferenceServiceFactory.getService().getConcept("CONTINENT");
        ReferenceObject europe = continent.getObject("UN_CODE", (Object)"150");
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("CONTINENT_COUNTRY");
        for (ReferenceObject member : relationship.getChildren(europe)) {
            selection.add(country, member);
        }
        System.out.println("selection:\n" + selection);
        System.out.println("filetring european countries...");
        Timer.start();
        global_aquaculture_production.filter(selection);
        Timer.stop();
        List<ObservationSeries> result = global_aquaculture_production.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to filter european countries"), (Timer.timeElapsed() < 6500L ? 1 : 0) != 0);
    }

    @Test
    public void testFilterGlobalAquacultureProductionByEnvironment() throws Exception {
        Selection selection = Selection.instance();
        Concept environment = ReferenceServiceFactory.getService().getConcept("ENVIRONMENT");
        ReferenceObject freshwater = environment.getObject("CODE", (Object)"FRESHWATER");
        selection.add(environment, freshwater);
        System.out.println("selection:\n" + selection);
        System.out.println("filetring freshwater environment...");
        Timer.start();
        global_aquaculture_production.filter(selection);
        Timer.stop();
        List<ObservationSeries> result = global_aquaculture_production.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to filter on freshwater environment"), (Timer.timeElapsed() < 6500L ? 1 : 0) != 0);
    }

    @Test
    public void testGroupGlobalAquacultureProductionByContinent() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept continent = ReferenceServiceFactory.getService().getConcept("CONTINENT");
        for (ReferenceObject object : continent.getObjects()) {
            selection.add(country, object);
        }
        ReferenceObject all = ReferenceObject.ALL;
        selection.add(ReferenceServiceFactory.getService().getConcept("SPECIES"), all);
        selection.add(ReferenceServiceFactory.getService().getConcept("AREA"), all);
        selection.add(ReferenceServiceFactory.getService().getConcept("ENVIRONMENT"), all);
        System.out.println("selection:\n" + selection);
        System.out.println("grouping by continent...");
        Timer.start();
        global_aquaculture_production.aggregate(selection);
        Timer.stop();
        List<ObservationSeries> result = global_aquaculture_production.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to group by Continent"), (Timer.timeElapsed() < 6500L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTopOthersPercent() throws Exception {
        TopCriteria criteria = new TopCriteria(ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_t_1"), TopCriteria.CriteriaType.TOP_RECORDS_PERCENT, 10.0);
        System.out.println("calculating top others (percent)...");
        Timer.start();
        global_aquaculture_production.aggregate(criteria, new ObservationPeriod("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = global_aquaculture_production.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate top others(percent)"), (Timer.timeElapsed() < 10000L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTopOthersNumberOnCalculatedMeasure() throws Exception {
        CalculatedMeasureDefinition definition = CalculatedMeasureDefinitionFactory.create("Arithmetic mean");
        definition.setFunction(FunctionFactory.getFunction("ARITHMETIC_MEAN"));
        global_aquaculture_production.addCalculatedMeasureDefinition(definition);
        ReferenceObject measure = ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_t_1");
        TopCriteria criteria = new TopCriteria(measure, TopCriteria.CriteriaType.TOP_RECORDS_NUMBER, 5.0);
        System.out.println("calculating top others (number) on measure [" + measure.getAttribute("CODE") + "] and calculated measure...");
        Timer.start();
        global_aquaculture_production.aggregate(criteria, definition);
        Timer.stop();
        List<ObservationSeries> result = global_aquaculture_production.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec\n");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        global_aquaculture_production.removeCalculatedMeasureDefinition(definition);
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate top others(number) on calculated measure"), (Timer.timeElapsed() < 10000L ? 1 : 0) != 0);
    }
}

