/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.test;

import java.util.List;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.common.utils.RuntimeMemory;
import org.fao.fi.fishstat.data.common.utils.Timer;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TradeTimeseriesTestCase {
    private static Dataset trade;
    private static Timeseries trade_production;

    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
        Timer.start();
        trade = TimeseriesServiceFactory.getService().getDataset("GLOBAL_TRADE");
        trade_production = trade.getTimeseries("PRODUCTION");
        Timer.stop();
        System.out.println("Set up took: " + Timer.timeElapsed() + "ms");
    }

    @Before
    public void setUpTest() throws Exception {
        trade_production.reset();
        System.out.println("getting observations...");
        Timer.start();
        trade_production.getObservations();
        Timer.stop();
        RuntimeMemory.printStats();
        System.out.println("ready in " + Timer.timeElapsed() + "msec");
    }

    @After
    public void tearDownTest() {
        RuntimeMemory.printStats();
    }

    @Test
    public void testRepeatedFilter() throws Exception {
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept continent = ReferenceServiceFactory.getService().getConcept("CONTINENT");
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("CONTINENT_COUNTRY");
        int keys_size = trade_production.getDataset().getDimensions().size();
        int measures_size = trade_production.getObservationPeriods().size();
        for (ReferenceObject c : continent.getObjects()) {
            System.out.println("filetring on " + c);
            Selection selection = Selection.instance();
            selection.addAll(country, relationship.getChildren(c));
            System.out.println("selection:\n" + selection);
            Timer.start();
            trade_production.filter(selection);
            Timer.stop();
            List<ObservationSeries> result = trade_production.getObservations();
            System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
            for (ObservationSeries series : result) {
                series.getKeys();
                int index = 0;
                while (index < keys_size) {
                    series.getKey(index);
                    ++index;
                }
                series.getMeasures();
                index = 0;
                while (index < measures_size) {
                    series.getMeasure(index);
                    ++index;
                }
            }
            trade_production.reset();
            RuntimeMemory.printStats();
        }
    }

    @Test
    public void filterTradeFlowTest() throws Exception {
        Selection selection = Selection.instance();
        Concept tf = ReferenceServiceFactory.getService().getConcept("TRADE_FLOW");
        selection.add(tf, tf.getObject("ALPHA_CODE", (Object)"I"));
        selection.add(tf, tf.getObject("ALPHA_CODE", (Object)"E"));
        Timer.start();
        trade_production.filter(selection);
        Timer.stop();
        System.out.println("took " + Timer.timeElapsed() + "ms to filter " + trade_production.getObservations().size() + " observations");
    }
}

