/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.properties;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import org.eclipse.jface.preference.PreferenceStore;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.core.model.functions.CalculatedMeasureDefinitionWrapper;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;

public class CalculatedMeasuresProperties
extends Observable
implements IFSActions {
    private TimeSeriesProperties timeSeriesProperties;
    private boolean showColumns = true;
    private LinkedHashMap<String, CalculatedMeasureDefinitionWrapper> measures;
    private String id;

    public CalculatedMeasuresProperties(TimeSeriesProperties timeSeriesProperties) {
        this.timeSeriesProperties = timeSeriesProperties;
        this.measures = new LinkedHashMap();
        this.id = "timeseries." + timeSeriesProperties.getTimeseries().getAcronym() + ".measures";
    }

    public Map<String, CalculatedMeasureDefinitionWrapper> getMeasures() {
        return this.measures;
    }

    public CalculatedMeasureDefinitionWrapper getMeasures(int idx) {
        return new LinkedList<CalculatedMeasureDefinitionWrapper>(this.measures.values()).get(idx);
    }

    public int size() {
        return this.measures.size();
    }

    public void addMeasureDefinition(CalculatedMeasureDefinitionWrapper measure) {
        this.measures.put(measure.getMeasureName(), measure);
        this.timeSeriesProperties.datasetProperties.addAction(11, 23, 93);
        this.timeSeriesProperties.datasetProperties.setChanged();
        this.notifyObservers();
    }

    public void removeMeasures(CalculatedMeasureDefinitionWrapper[] measures) {
        CalculatedMeasureDefinitionWrapper[] calculatedMeasureDefinitionWrapperArray = measures;
        int n = measures.length;
        int n2 = 0;
        while (n2 < n) {
            CalculatedMeasureDefinitionWrapper measureWrapper = calculatedMeasureDefinitionWrapperArray[n2];
            this.measures.remove(measureWrapper.getMeasureName());
            ++n2;
        }
        this.timeSeriesProperties.datasetProperties.addAction(11, 23);
        this.timeSeriesProperties.datasetProperties.setChanged();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isUsedName(String name) {
        return this.measures.containsKey(name);
    }

    public boolean showColumns() {
        return this.showColumns;
    }

    public TimeSeriesProperties getTimeSeriesProperties() {
        return this.timeSeriesProperties;
    }

    public Timeseries getTimeseries() {
        return this.timeSeriesProperties.getTimeseries();
    }

    public void setTimeSeriesProperties(TimeSeriesProperties timeSeriesProperties) {
        this.timeSeriesProperties = timeSeriesProperties;
    }

    public void setShowColumns(boolean showColumns) {
        this.showColumns = showColumns;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
    }

    public void saveMeasureProperties(PreferenceStore store) {
        store.setValue(String.valueOf(this.id) + ".size", this.measures.size());
        for (CalculatedMeasureDefinitionWrapper caDefinitionWrapper : this.measures.values()) {
            caDefinitionWrapper.saveDefinitionProperties(store);
        }
        try {
            store.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void loadMeasureProperties(PreferenceStore store) {
        int size = store.getInt(String.valueOf(this.id) + ".size");
        int i = 0;
        while (i < size) {
            CalculatedMeasureDefinitionWrapper wrapper = new CalculatedMeasureDefinitionWrapper(this, i);
            this.measures.put(wrapper.getMeasureName(), wrapper);
            ++i;
        }
    }
}

