/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.management.descriptors;

import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.AttachmentDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DatasetDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DimensionDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.TimeseriesDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.impl.AttachmentDescriptorImpl;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.impl.DatasetDescriptorImpl;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.impl.DimensionDescriptorImpl;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.impl.TimeseriesDescriptorImpl;

public class DescriptorsFactory {
    public static DatasetDescriptor createDatasetDescriptor(DataSource dataSource, List<DimensionDescriptor> dimensions, String acronym, MultilingualString name, MultilingualString description, String url, Version version, String citation) {
        return new DatasetDescriptorImpl(dataSource, dimensions, acronym, name, description, url, version, citation);
    }

    public static TimeseriesDescriptor createTimeseriesDescriptor(Dataset dataset, DataSource datasource, String acronym, MultilingualString name, MultilingualString description, TimeResolution resolution, ObservationPeriod firstObservationPeriod, ObservationPeriod lastObservationPeriod, Map<Attribute, String> attributes, Version version) {
        return new TimeseriesDescriptorImpl(dataset, datasource, acronym, name, description, resolution, firstObservationPeriod, lastObservationPeriod, attributes, version);
    }

    public static DimensionDescriptor createDimensionDescriptor(String acronym, MultilingualString name, MultilingualString description, Concept concept, org.fao.fi.fishstat.data.reference.api.Attribute attribute, boolean observedMeasure) {
        return new DimensionDescriptorImpl(acronym, name, description, concept, attribute, observedMeasure);
    }

    public static AttachmentDescriptor createAttachmentDescriptor(String acronym, Dataset dataset, MultilingualString name, MultilingualString description, AttachmentType type, String mimeType, MultilingualString file) {
        return new AttachmentDescriptorImpl(acronym, dataset, name, description, type, mimeType, file);
    }
}

