/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import java.lang.reflect.Method;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.daosupport.DAOAdapter;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.exceptions.ReflectionException;
import org.fao.fi.fishstat.data.common.classloader.ClassLoaderFactory;

public class ReferenceServiceHelper {
    private static Class<?> getReferenceDAOFactoryClass(String acronym) throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("Ref").append(Commons.getJavaName((String)acronym)).append("DaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    private static Class<?> getRelationshipDAOFactoryClass(String acronym) throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("Rel").append(Commons.getJavaName((String)acronym)).append("DaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    private static Class<?> getRmdConceptDAOFactoryClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("RmdConceptDaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getRmdConceptDTOClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("RmdConcept");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    private static Class<?> getRmdRelationshipDAOFactoryClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("RmdRelationshipDaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getRmdRelationshipDTOClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("RmdRelationship");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    private static Class<?> getRmdAttributeDAOFactoryClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("RmdAttributeDaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getRmdAttributeDTOClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("RmdAttribute");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getReferenceDTOClass(String acronym) throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("Ref").append(Commons.getJavaName((String)acronym));
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getRelationshipDTOClass(String acronym) throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("Rel").append(Commons.getJavaName((String)acronym));
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static GenericDAO getReferenceDAO(String acronym) throws ReflectionException {
        try {
            Class<?> factory_class = ReferenceServiceHelper.getReferenceDAOFactoryClass(acronym);
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    public static GenericDAO getRelationshipDAO(String acronym) throws ReflectionException {
        try {
            Class<?> factory_class = ReferenceServiceHelper.getRelationshipDAOFactoryClass(acronym);
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    public static GenericDAO getRmdRelationshipDao() throws ReflectionException {
        try {
            Class<?> factory_class = ReferenceServiceHelper.getRmdRelationshipDAOFactoryClass();
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    public static GenericDAO getRmdConceptDao() throws ReflectionException {
        try {
            Class<?> factory_class = ReferenceServiceHelper.getRmdConceptDAOFactoryClass();
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    public static GenericDAO getRmdAttributeDao() throws ReflectionException {
        try {
            Class<?> factory_class = ReferenceServiceHelper.getRmdAttributeDAOFactoryClass();
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }
}

