/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.structure;

import java.io.File;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WorkspaceStructureImportExportLegacy {
    public static final String LEGACY_DATE_FORMAT = "EEE MMM dd HH:mm:ss ZZZZ yyyy";

    public static void readWorkspace(WorkspaceModel wks, String xmlMessage, boolean incrementVersion) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        StringReader reader = new StringReader(xmlMessage);
        InputSource inputSource = new InputSource(reader);
        Document doc = documentBuilder.parse(inputSource);
        Element rootElement = doc.getDocumentElement();
        wks.setAcronym(rootElement.getAttribute("acronym"));
        wks.setVersion(new VersionId(rootElement.getAttribute("version")));
        if (incrementVersion) {
            wks.getVersion().setMajor(wks.getVersion().getMajor() + 1);
        }
        if (incrementVersion) {
            wks.setCompatibility(CoreCommons.COMPATIBILITY_MAX.clone());
        } else {
            wks.setCompatibility(new VersionId(rootElement.getAttribute("compatibility")));
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(LEGACY_DATE_FORMAT);
            Date date = simpleDateFormat.parse(rootElement.getElementsByTagName("date").item(0).getTextContent());
            wks.setDate(date);
        }
        catch (Exception exception) {}
        NodeList namesList = rootElement.getElementsByTagName("name");
        int i = 0;
        while (i < namesList.getLength()) {
            Element nameElement = (Element)namesList.item(i);
            if (nameElement.getParentNode() == rootElement) {
                wks.getName().setValue(nameElement.getAttribute("xml:lang"), nameElement.getTextContent());
            }
            ++i;
        }
        NodeList descriptionsList = rootElement.getElementsByTagName("description");
        int i2 = 0;
        while (i2 < descriptionsList.getLength()) {
            Element descriptionElement = (Element)descriptionsList.item(i2);
            wks.getDescription().setValue(descriptionElement.getAttribute("xml:lang"), descriptionElement.getTextContent());
            ++i2;
        }
        NodeList providersList = rootElement.getElementsByTagName("provider");
        int i3 = 0;
        while (i3 < providersList.getLength()) {
            Element providerElement = (Element)providersList.item(i3);
            wks.getProvider().setValue(providerElement.getAttribute("xml:lang"), providerElement.getTextContent());
            ++i3;
        }
        reader.close();
    }

    public static void exportWorkspace(WorkspaceModel ws, File xml_file) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(WorkspaceStructureImportExportLegacy.toXml("", ws));
        StreamResult result = new StreamResult(xml_file);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, result);
    }

    private static Document toXml(String protocol, WorkspaceModel ws) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document res = documentBuilder.newDocument();
        Element rootElement = res.createElement("workspace");
        WorkspaceStructureImportExportLegacy.buildXmlElement(rootElement, ws);
        res.appendChild(rootElement);
        return res;
    }

    private static void buildXmlElement(Element rootElement, WorkspaceModel ws) {
        rootElement.setAttribute("acronym", ws.getAcronym());
        rootElement.setAttribute("version", ws.getVersion().toString());
        rootElement.setAttribute("compatibility", ws.getCompatibility().toString());
        WorkspaceStructureImportExportLegacy.toXml(ws.getName(), rootElement, "name");
        WorkspaceStructureImportExportLegacy.toXml(ws.getDescription(), rootElement, "description");
        WorkspaceStructureImportExportLegacy.toXml(ws.getProvider(), rootElement, "provider");
        Element dateElement = rootElement.getOwnerDocument().createElement("date");
        dateElement.setTextContent(ws.getDate() != null ? ws.getDate().toString() : "");
        rootElement.appendChild(dateElement);
        Element dbmsElement = rootElement.getOwnerDocument().createElement("dbms");
        dbmsElement.setAttribute("id", "EMBEDDED_DB");
        dbmsElement.setAttribute("type", "EMBEDDED_DB");
        dbmsElement.setAttribute("driver", "EMBEDDED_DB");
        Element schemaElement = rootElement.getOwnerDocument().createElement("schema");
        schemaElement.setTextContent(ws.getDbSchema());
        dbmsElement.appendChild(schemaElement);
        Element usernameElement = rootElement.getOwnerDocument().createElement("username");
        usernameElement.setTextContent(ws.getDbUsername());
        dbmsElement.appendChild(usernameElement);
        Element passwordElement = rootElement.getOwnerDocument().createElement("password");
        passwordElement.setTextContent(ws.getDbPassword());
        dbmsElement.appendChild(passwordElement);
        rootElement.appendChild(dbmsElement);
    }

    private static void toXml(MultilingualStringWrapper wrapper, Element rootElement, String tagName) {
        for (String locale : MultilingualString.LANGUAGES) {
            Element element = rootElement.getOwnerDocument().createElement(tagName);
            element.setAttribute("xml:lang", locale);
            element.setTextContent(wrapper.getValue(locale));
            rootElement.appendChild(element);
        }
    }
}

