/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.composites.DimensionMetadataPanel;

public class DimensionTabbedDisplay
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Dataset dataset;
    private String lang = null;
    private CLabel lblTitle;
    private CTabFolder tabFolder;

    public DimensionTabbedDisplay(Composite parent, int style, String lang) {
        super(parent, style);
        this.lang = lang;
        this.initComponents();
    }

    private void initComponents() {
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.lblTitle = new CLabel((Composite)this, 0);
        this.lblTitle.setForeground(SWTResourceManager.getColor(10));
        this.lblTitle.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.lblTitle.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblTitle.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblTitle.setBackgroundMode(1);
        this.lblTitle.setText(String.valueOf(ComponentsActivator.getDefault().getLocalString("label.dataset.dimensions")) + ":");
    }

    public void renderDataset(Dataset dataset) {
        if (dataset != null) {
            this.dataset = dataset;
            this.lblTitle.setText(dataset.getName().getValue(this.lang));
            if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
                this.tabFolder.dispose();
            }
            this.tabFolder = new CTabFolder((Composite)this, 2048);
            GridData gridData = new GridData(4, 4, true, true, 1, 1);
            gridData.widthHint = 535;
            this.tabFolder.setLayoutData((Object)gridData);
            this.tabFolder.setSelectionForeground(ComponentsCommons.getColor(0, 0, 128));
            this.tabFolder.setSelectionBackground(new Color[]{Display.getCurrent().getSystemColor(22), Display.getCurrent().getSystemColor(32), Display.getCurrent().getSystemColor(32)}, new int[]{50, 100});
            this.tabFolder.setBorderVisible(true);
            CTabItem[] tabitems = new CTabItem[dataset.getDimensions().size()];
            int i = 0;
            while (i < dataset.getDimensions().size()) {
                tabitems[i] = new CTabItem(this.tabFolder, 0);
                tabitems[i].setText(CoreUtils.getCurrentLang((MultilingualString)((Dimension)dataset.getDimensions().get(i)).getName(), (String)this.lang));
                tabitems[i].setControl((Control)new DimensionMetadataPanel((Composite)this.tabFolder, (Dimension)dataset.getDimensions().get(i), this.lang));
                ++i;
            }
            this.tabFolder.setSelection(tabitems[0]);
            this.layout(true);
        } else {
            this.lblTitle.setText(ComponentsActivator.getDefault().getLocalString("label.no.dataset.selected"));
            if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
                this.tabFolder.dispose();
                this.tabFolder = null;
            }
            this.layout(true);
        }
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public Dataset getDataset() {
        return this.dataset;
    }
}

