/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtility {
    public static final void unzip(URL url, File extractTo) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(url.openConnection().getInputStream()));
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            File file = new File(extractTo, entry.getName());
            System.out.println("extracting: " + file);
            if (entry.isDirectory()) {
                if (file.exists() || file.mkdirs()) continue;
                throw new Exception("Unable to create directory path: " + file.getPath());
            }
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new Exception("Unable to create directory path: " + file.getPath());
            }
            byte[] data = new byte[2048];
            BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(file), 2048);
            while ((count = zis.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zis.close();
    }

    public static final void unzip(String url, File extractTo) throws Exception {
        URL zip_url = new URL(url);
        ZipUtility.unzip(zip_url, extractTo);
    }
}

