/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreCache;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class TimeseriestMetadataComposite
extends Composite {
    private Label lblName;
    private Label lblAcronymLabel;
    private Label lblAcronym;
    private Label lblAttributesLabel;
    private Table tabAttributes;
    private TableColumn colAttributeValue;
    private TableColumn colAttributeName;
    private TableColumn colAttributeDescription;
    private Label lblFirstPeriodLabel;
    private Label lblLastPeriodLabel;
    private Label lblFirstPeriod;
    private Label lblLastPeriod;
    private Label lblTimeResolutionLabel;
    private Label lblTimeResolution;
    private Label lblNameLabel;
    private Label lblSource;
    private Label lblSourceLabel;
    private Label lblSeriesNumberLabel;
    private Label lblSeriesNumber;
    private Label lblObservationsNuberLabel;
    private Label lblObservationsNuber;
    private Label lblTimeseriesAttributes;

    public TimeseriestMetadataComposite(Composite parent, int style) {
        super(parent, style);
        this.setBackgroundMode(2);
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(ComponentsCommons.getColor((int)1));
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        this.setLayout((Layout)gridLayout);
        this.lblNameLabel = new Label((Composite)this, 0);
        this.lblNameLabel.setText(Activator.getLocalString("label.name.first.upper"));
        this.lblNameLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        this.lblNameLabel.setForeground(ComponentsCommons.getColor((int)10));
        GridData gridData = new GridData(4, 4, false, false, 1, 1);
        gridData.widthHint = 112;
        this.lblNameLabel.setLayoutData((Object)gridData);
        this.lblName = new Label((Composite)this, 0);
        this.lblName.setFont(SWTResourceManager.getFont("Tahoma", 7, 0));
        this.lblName.setForeground(ComponentsCommons.getColor((int)2));
        GridData gridData_3 = new GridData(4, 4, false, false, 1, 1);
        gridData_3.widthHint = 149;
        this.lblName.setLayoutData((Object)gridData_3);
        this.lblSourceLabel = new Label((Composite)this, 0);
        this.lblSourceLabel.setBackground(ComponentsCommons.getColor((int)1));
        this.lblSourceLabel.setText(Activator.getLocalString("label.source.first.upper"));
        this.lblSourceLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblSourceLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        this.lblSource = new Label((Composite)this, 0);
        this.lblSource.setFont(SWTResourceManager.getFont("Tahoma", 7, 0));
        this.lblSource.setForeground(ComponentsCommons.getColor((int)2));
        GridData gridData_7 = new GridData(4, 4, false, false, 1, 1);
        gridData_7.widthHint = 143;
        this.lblSource.setLayoutData((Object)gridData_7);
        this.lblTimeResolutionLabel = new Label((Composite)this, 0);
        this.lblTimeResolutionLabel.setBackground(ComponentsCommons.getColor((int)1));
        this.lblTimeResolutionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblTimeResolutionLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblTimeResolutionLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        this.lblTimeResolutionLabel.setText(Activator.getLocalString("label.time.resolution"));
        this.lblTimeResolution = new Label((Composite)this, 0);
        this.lblTimeResolution.setFont(SWTResourceManager.getFont("Tahoma", 7, 0));
        this.lblTimeResolution.setBackground(ComponentsCommons.getColor((int)1));
        this.lblTimeResolution.setForeground(ComponentsCommons.getColor((int)2));
        GridData gridData_8 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData_8.widthHint = 116;
        this.lblTimeResolution.setLayoutData((Object)gridData_8);
        this.lblAcronymLabel = new Label((Composite)this, 0);
        this.lblAcronymLabel.setText(Activator.getLocalString("label.acronym.first.upper"));
        this.lblAcronymLabel.setBackground(ComponentsCommons.getColor((int)1));
        this.lblAcronymLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblAcronymLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        GridData gridData_4 = new GridData(4, 4, false, false, 1, 1);
        gridData_4.widthHint = 86;
        this.lblAcronymLabel.setLayoutData((Object)gridData_4);
        this.lblAcronym = new Label((Composite)this, 0);
        this.lblAcronym.setFont(SWTResourceManager.getFont("Tahoma", 7, 0));
        this.lblAcronym.setBackground(ComponentsCommons.getColor((int)1));
        this.lblAcronym.setForeground(ComponentsCommons.getColor((int)2));
        GridData gridData_6 = new GridData(4, 4, false, false, 1, 1);
        gridData_6.widthHint = 68;
        this.lblAcronym.setLayoutData((Object)gridData_6);
        this.lblFirstPeriodLabel = new Label((Composite)this, 0);
        this.lblFirstPeriodLabel.setBackground(ComponentsCommons.getColor((int)1));
        this.lblFirstPeriodLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        this.lblFirstPeriodLabel.setForeground(ComponentsCommons.getColor((int)10));
        GridData gridData_1 = new GridData(4, 4, false, false, 1, 1);
        gridData_1.widthHint = 109;
        this.lblFirstPeriodLabel.setLayoutData((Object)gridData_1);
        this.lblFirstPeriodLabel.setText(Activator.getLocalString("label.first.period"));
        this.lblFirstPeriod = new Label((Composite)this, 0);
        this.lblFirstPeriod.setFont(SWTResourceManager.getFont("Tahoma", 7, 0));
        this.lblFirstPeriod.setBackground(ComponentsCommons.getColor((int)1));
        this.lblFirstPeriod.setForeground(ComponentsCommons.getColor((int)2));
        GridData gridData_10 = new GridData(4, 4, false, false, 1, 1);
        gridData_10.widthHint = 74;
        this.lblFirstPeriod.setLayoutData((Object)gridData_10);
        this.lblLastPeriodLabel = new Label((Composite)this, 0);
        this.lblLastPeriodLabel.setBackground(ComponentsCommons.getColor((int)1));
        this.lblLastPeriodLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblLastPeriodLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        GridData gridData_5 = new GridData(4, 4, false, false, 1, 1);
        gridData_5.widthHint = 73;
        this.lblLastPeriodLabel.setLayoutData((Object)gridData_5);
        this.lblLastPeriodLabel.setText(Activator.getLocalString("label.last.period"));
        this.lblLastPeriod = new Label((Composite)this, 0);
        this.lblLastPeriod.setFont(SWTResourceManager.getFont("Tahoma", 7, 0));
        this.lblLastPeriod.setBackground(ComponentsCommons.getColor((int)1));
        this.lblLastPeriod.setForeground(ComponentsCommons.getColor((int)2));
        GridData gridData_9 = new GridData(4, 4, false, false, 1, 1);
        gridData_9.widthHint = 113;
        this.lblLastPeriod.setLayoutData((Object)gridData_9);
        this.lblSeriesNumberLabel = new Label((Composite)this, 0);
        this.lblSeriesNumberLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblSeriesNumberLabel.setBackground(ComponentsCommons.getColor((int)1));
        this.lblSeriesNumberLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        this.lblSeriesNumberLabel.setText(Activator.getLocalString("label.series.no.dot"));
        this.lblSeriesNumber = new Label((Composite)this, 0);
        this.lblSeriesNumber.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblSeriesNumber.setForeground(ComponentsCommons.getColor((int)2));
        this.lblSeriesNumber.setBackground(ComponentsCommons.getColor((int)1));
        this.lblSeriesNumber.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        this.lblObservationsNuberLabel = new Label((Composite)this, 0);
        GridData gridData_11 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData_11.widthHint = 112;
        this.lblObservationsNuberLabel.setLayoutData((Object)gridData_11);
        this.lblObservationsNuberLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblObservationsNuberLabel.setBackground(ComponentsCommons.getColor((int)1));
        this.lblObservationsNuberLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        this.lblObservationsNuberLabel.setText(Activator.getLocalString("label.observation.no.dot"));
        this.lblObservationsNuber = new Label((Composite)this, 0);
        this.lblObservationsNuber.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblObservationsNuber.setForeground(ComponentsCommons.getColor((int)2));
        this.lblObservationsNuber.setBackground(ComponentsCommons.getColor((int)1));
        this.lblObservationsNuber.setFont(SWTResourceManager.getFont("Tahoma", 7, 1));
        this.lblAttributesLabel = new Label((Composite)this, 0);
        this.lblAttributesLabel.setBackground(ComponentsCommons.getColor((int)1));
        this.lblAttributesLabel.setForeground(ComponentsCommons.getColor((int)10));
        this.lblAttributesLabel.setFont(SWTResourceManager.getFont("Tahoma", 7, 3));
        this.lblAttributesLabel.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.lblAttributesLabel.setText(Activator.getLocalString("label.attributes.first.upper"));
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        this.lblTimeseriesAttributes = new Label((Composite)this, 0);
        this.lblTimeseriesAttributes.setForeground(SWTResourceManager.getColor(0, 51, 102));
        this.lblTimeseriesAttributes.setFont(SWTResourceManager.getFont("Segoe UI", 8, 2));
        GridData gd_lblNewLabel = new GridData(4, 4, false, false, 5, 1);
        gd_lblNewLabel.heightHint = 14;
        gd_lblNewLabel.widthHint = 110;
        this.lblTimeseriesAttributes.setLayoutData((Object)gd_lblNewLabel);
        this.tabAttributes = new Table((Composite)this, 2048);
        this.tabAttributes.setBackgroundMode(2);
        this.tabAttributes.setBackground(SWTResourceManager.getColor(240, 248, 255));
        this.tabAttributes.setHeaderVisible(true);
        GridData gd_tabAttributes = new GridData(4, 4, true, true, 4, 1);
        gd_tabAttributes.heightHint = 55;
        this.tabAttributes.setLayoutData((Object)gd_tabAttributes);
        this.colAttributeName = new TableColumn(this.tabAttributes, 0);
        this.colAttributeName.setResizable(false);
        this.colAttributeName.setWidth(80);
        this.colAttributeName.setText(Activator.getLocalString("label.name.first.upper"));
        this.colAttributeValue = new TableColumn(this.tabAttributes, 0x1000000);
        this.colAttributeValue.setWidth(40);
        this.colAttributeValue.setText(Activator.getLocalString("label.value.first.upper"));
        this.colAttributeDescription = new TableColumn(this.tabAttributes, 0);
        this.colAttributeDescription.setWidth(1000);
        this.colAttributeDescription.setText(Activator.getLocalString("label.description.first.upper"));
    }

    public void renderTimeseries(Timeseries ts) {
        if (ts != null) {
            int i = this.tabAttributes.getItemCount() - 1;
            while (i >= 0) {
                this.tabAttributes.getItem(0).dispose();
                --i;
            }
            this.lblNameLabel.setVisible(true);
            this.lblName.setText(CoreUtils.getCurrentLang((MultilingualString)ts.getName(), (String)Activator.getLanguage()));
            this.lblAcronymLabel.setVisible(true);
            this.lblAcronym.setText(ts.getAcronym());
            this.lblFirstPeriodLabel.setVisible(true);
            this.lblFirstPeriod.setText(ts.getFirstObservationPeriod().getISO8601());
            this.lblLastPeriodLabel.setVisible(true);
            this.lblLastPeriod.setText(ts.getLastObservationPeriod().getISO8601());
            this.lblTimeResolutionLabel.setVisible(true);
            this.lblTimeResolution.setText(this.calcTimeResolution(ts.getTimeResolution()));
            this.lblSourceLabel.setVisible(true);
            this.lblSource.setText(ts.getDataSource().getName());
            this.lblTimeseriesAttributes.setVisible(true);
            try {
                if (ts.getAttributes().keySet().size() == 0) {
                    this.tabAttributes.setVisible(false);
                    this.lblTimeseriesAttributes.setText(Activator.getLocalString("label.no.attributes.to.display"));
                } else {
                    this.lblTimeseriesAttributes.setText(Activator.getLocalString("label.timeseries.attributes"));
                    for (Map.Entry entry : ts.getAttributes().entrySet()) {
                        Attribute attribute = (Attribute)entry.getKey();
                        TableItem item = new TableItem(this.tabAttributes, 0);
                        item.setText(0, CoreUtils.getCurrentLang((MultilingualString)attribute.getName(), (String)Activator.getLanguage()));
                        item.setText(1, (String)entry.getValue());
                        item.setText(2, CoreUtils.getAttributeLabel((Object)attribute.getDescription(), (String)Activator.getLanguage()));
                    }
                    this.tabAttributes.setVisible(true);
                }
            }
            catch (TimeseriesServiceException e) {
                e.printStackTrace();
            }
            int series_num = CoreCache.getTimeseriesSize((Timeseries)ts);
            this.lblSeriesNumberLabel.setVisible(true);
            this.lblSeriesNumber.setText(Integer.toString(series_num));
            this.lblObservationsNuberLabel.setVisible(true);
            this.lblObservationsNuber.setText(Integer.toString(series_num * ts.getObservationPeriods().size()));
        } else {
            this.lblNameLabel.setVisible(false);
            this.lblName.setText(Activator.getLocalString("label.no.time.series.selected.first.upper"));
            this.lblAcronymLabel.setVisible(false);
            this.lblAcronym.setText("");
            this.lblFirstPeriodLabel.setVisible(false);
            this.lblFirstPeriod.setText("");
            this.lblLastPeriodLabel.setVisible(false);
            this.lblLastPeriod.setText("");
            this.lblTimeResolutionLabel.setVisible(false);
            this.lblTimeResolution.setText("");
            this.lblSourceLabel.setVisible(false);
            this.lblSource.setText("");
            this.lblSeriesNumberLabel.setVisible(false);
            this.lblSeriesNumber.setText("");
            this.lblObservationsNuberLabel.setVisible(false);
            this.lblObservationsNuber.setText("");
            this.lblTimeseriesAttributes.setVisible(false);
            this.lblAttributesLabel.setVisible(false);
            this.tabAttributes.setVisible(false);
            int i = this.tabAttributes.getItemCount() - 1;
            while (i >= 0) {
                this.tabAttributes.getItem(0).dispose();
                --i;
            }
        }
    }

    private String calcTimeResolution(TimeResolution tr) {
        if (tr.equals((Object)TimeResolution.YEAR)) {
            return "YEAR";
        }
        if (tr.equals((Object)TimeResolution.QUARTER)) {
            return "QUARTER";
        }
        if (tr.equals((Object)TimeResolution.MONTH)) {
            return "MONTH";
        }
        return tr.toString();
    }
}

