/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.data;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.session.SessionDescriptor;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.aggregation.AggregationDialog;
import org.fao.fi.fishstat.gui.handler.base.AbstractHandlerWorkspaces;
import org.fao.fi.fishstat.gui.properties.dataset.sorting.AdvanceSortDialog;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedComparator;

public class SortHandler
extends AbstractHandlerWorkspaces {
    public static final String ID = "org.fao.fi.fishstat.gui.command.data.sort";
    public static final String PARAMETER_ID = "org.fao.fi.fishstat.gui.command.data.sort.par";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<SessionDescriptor> toProcess;
        String sort_par = event.getParameter(PARAMETER_ID);
        CoreRegistry coreRegistry = GuiCoreActivator.getDefault().getRegistry();
        final GuiSession session = (GuiSession)coreRegistry.getSessionOnFocus();
        if (session == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() == null) {
            return null;
        }
        AdvanceSortDialog dialog = new AdvanceSortDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), session, sort_par);
        int result = dialog.open();
        boolean relatives = Activator.getDefault().getPreferenceStore().getBoolean("core.join.related.series");
        List<SessionDescriptor> list = toProcess = relatives ? coreRegistry.findRelatives(session.getDescriptor()) : Arrays.asList(session.getDescriptor());
        if (result == 0) {
            for (SessionDescriptor sessionDescriptor : toProcess) {
                final IViewReference vr = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("org.fao.fi.fishstat.gui.display.views.multitable", "org.fao.fi.fishstat.gui.display.views.multitable-" + sessionDescriptor.getUuid().toString());
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            if (vr != null) {
                                MultiTableView multiTableView = (MultiTableView)vr.getView(true);
                                multiTableView.setCommonComparator(new UnifiedComparator(session.getTimeseriesProperties()));
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, AggregationDialog.class.getName(), "sort handler failed", (Throwable)e));
                }
            }
        }
        return null;
    }

    @Override
    public void updateEnablement(WorkspacesManager wsm) {
        this.setBaseEnabled(wsm.hasCurrentWorkspace() && !GuiCoreActivator.getDefault().getRegistry().getOpenSessions().isEmpty());
    }
}

