/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.Application;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.YearDateComposite;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class RecordDetailsView
extends ViewPart
implements ISelectionListener,
Observer {
    public static final String ID = "org.fao.fi.fishstat.gui.display.views.recorddetails";
    private ScrolledComposite scrolledComposite;
    private Composite parent;
    private YearDateComposite[] cells;
    private Composite panel;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.panel = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.panel);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 3;
        rowLayout.marginRight = 8;
        rowLayout.marginLeft = 15;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.pack = false;
        this.panel.setLayout((Layout)rowLayout);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void populateView() {
        if (this.panel.isDisposed() || this.scrolledComposite.isDisposed()) {
            return;
        }
        GuiSession session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        if (session != null) {
            session.addObserver((Observer)this);
            TimeSeriesProperties properties = session.getTimeseriesProperties();
            Application.display.syncExec(() -> {
                this.removeCells();
                this.scrolledComposite.setMinSize(400, properties.getPeriodsSize() * 2 + 20);
                this.cells = new YearDateComposite[properties.getPeriodsSize()];
                int i = 0;
                while (i < this.cells.length) {
                    this.cells[i] = new YearDateComposite(this.panel, properties.getPeriod(i).getISO8601());
                    ++i;
                }
                this.scrolledComposite.layout();
                this.panel.layout();
            });
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.populateView();
    }

    private void removeCells() {
        if (this.cells != null) {
            int i = 0;
            while (i < this.cells.length) {
                if (this.cells[i] != null && !this.cells[i].isDisposed()) {
                    this.cells[i].dispose();
                }
                ++i;
            }
        }
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof MultiTableView && this.cells != null) {
            try {
                TimeSeriesProperties properties = ((MultiTableView)part).getSession().getTimeseriesProperties();
                ObservationSeries record = (ObservationSeries)((IStructuredSelection)selection).getFirstElement();
                if (record == null) {
                    int index = 0;
                    while (index < this.cells.length) {
                        if (!this.cells[index].isDisposed()) {
                            this.cells[index].setMeasure(null);
                        }
                        ++index;
                    }
                } else {
                    Map measures = record.getMeasures();
                    int index = 0;
                    while (index < this.cells.length) {
                        Measure m;
                        Measure measure = m = properties.hasPeriod(index) ? (Measure)measures.get(properties.getPeriod(index)) : null;
                        if (!this.cells[index].isDisposed()) {
                            this.cells[index].setMeasure(m);
                            this.cells[index].layout();
                        }
                        ++index;
                    }
                }
            }
            catch (TimeseriesServiceException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "selectionChanged", (Throwable)e));
            }
        }
    }
}

