/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.DimensionNote;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DimensionTableLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final String IMAGE_DIMENSION_NOTE = "icons/fishstatj/cell_triangle_14x14.png";
    private Session session;
    private static Image imageNote;
    private static Image imageBlank;

    public DimensionTableLabelProvider(Session session) {
        this.session = session;
        Bundle bundle = FrameworkUtil.getBundle(DimensionTableLabelProvider.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(IMAGE_DIMENSION_NOTE), null);
        ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)url);
        imageNote = imageDesc.createImage();
        Display display = PlatformUI.getWorkbench().getDisplay();
        Color white = display.getSystemColor(1);
        ImageData imageData = new ImageData(14, 14, 8, new PaletteData(new RGB[]{white.getRGB()}));
        imageBlank = new Image((Device)display, imageData);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int columnIndex = cell.getColumnIndex() - 1;
        if (element instanceof ObservationSeries) {
            try {
                ObservationSeries obs = (ObservationSeries)element;
                FSDimensionColumnDescriptor descriptor = this.session.getSessionMetadata().getDimColumnDescriptor(columnIndex);
                ReferenceObject ro = CoreUtils.calcColumnReferenceObject((FSDimensionColumnDescriptor)descriptor, (ReferenceObject)obs.getKey(descriptor.getDimensionIdx()));
                if (ro == null) {
                    cell.setText(Activator.getLocalString("label.not.applicable"));
                    return;
                }
                if (ro.equals(ReferenceObject.NULL)) {
                    cell.setText("");
                    return;
                }
                if (ro.equals(ReferenceObject.ALL) || ro.equals(ReferenceObject.OTHERS) || ro.equals(ReferenceObject.UNKNOWN)) {
                    cell.setText(CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (String)"NAME", (String)Activator.getLanguage()));
                    return;
                }
                this.paintNotesIcon(descriptor, obs, ro, cell);
                if (ro.getConcept().equals(descriptor.getConcept())) {
                    String label = CoreUtils.getTextualValueLabel((ReferenceObject)ro, (FSDimensionColumnDescriptor)descriptor, (String)Activator.getLanguage());
                    cell.setText(label);
                } else {
                    cell.setText(CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)ro.getConcept().getNameAttribute(), (String)Activator.getLanguage()));
                }
            }
            catch (TimeseriesServiceException e) {
                ComponentsCommons.showExceptionWithStack((Throwable)e);
            }
            catch (ReferenceServiceException e) {
                ComponentsCommons.showExceptionWithStack((Throwable)e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                cell.setText("");
            }
        }
    }

    private void paintNotesIcon(FSDimensionColumnDescriptor descriptor, ObservationSeries obs, ReferenceObject ro, ViewerCell cell) {
        if (!descriptor.getDimension().hasNote()) {
            return;
        }
        Dataset dataset = obs.getTimeseries().getDataset();
        DimensionNote dimensionNote = dataset.getNotes(ro.getConcept(), Activator.getLanguage());
        if (dimensionNote != null) {
            if (dimensionNote.getNoteString(ro) == null) {
                cell.setImage(imageBlank);
            } else {
                cell.setImage(imageNote);
            }
        } else {
            cell.setImage(imageBlank);
        }
    }
}

